@props([
    'status' => 'default',
    'size' => 'default',
    'pulse' => false,
    'label' => null
])

@php
    $statuses = [
        'online' => 'bg-success-500',
        'offline' => 'bg-slate-400',
        'away' => 'bg-warning-500',
        'busy' => 'bg-danger-500',
        'default' => 'bg-slate-400',
    ];
    
    $sizes = [
        'sm' => 'h-2 w-2',
        'default' => 'h-2.5 w-2.5',
        'lg' => 'h-3 w-3',
    ];
    
    $statusClass = $statuses[$status] ?? $statuses['default'];
    $sizeClass = $sizes[$size] ?? $sizes['default'];
@endphp

<span class="inline-flex items-center gap-2">
    <span @class([
        $statusClass,
        $sizeClass,
        'rounded-full',
        'animate-pulse' => $pulse
    ])></span>
    
    @if($label)
        <span class="text-sm text-slate-600">{{ $label }}</span>
    @endif
</span>

