@props([
    'searchPlaceholder' => 'Search...',
    'searchName' => 'search'
])

<div {{ $attributes->merge(['class' => 'flex flex-col gap-4 sm:flex-row sm:items-center sm:justify-between']) }}>
    <!-- Search -->
    <div class="w-full sm:max-w-xs">
        <x-admin.search-input 
            :placeholder="$searchPlaceholder" 
            :name="$searchName"
            wire:model.live.debounce.300ms="{{ $searchName }}"
        />
    </div>
    
    <!-- Filters & Actions -->
    <div class="flex flex-wrap items-center gap-3">
        {{ $slot }}
    </div>
</div>

