@props([
    'striped' => false,
    'hoverable' => true,
])

<div {{ $attributes->merge(['class' => 'overflow-x-auto']) }}>
    <table class="w-full">
        @if(isset($header))
            <thead>
                <tr class="border-b border-white/5 bg-white/[0.02]">
                    {{ $header }}
                </tr>
            </thead>
        @endif
        @if(isset($body))
            <tbody class="divide-y divide-white/5 {{ $striped ? '[&>tr:nth-child(even)]:bg-white/[0.02]' : '' }} {{ $hoverable ? '[&>tr:hover]:bg-white/[0.03]' : '' }}">
                {{ $body }}
            </tbody>
        @else
            <tbody class="divide-y divide-white/5 {{ $striped ? '[&>tr:nth-child(even)]:bg-white/[0.02]' : '' }} {{ $hoverable ? '[&>tr:hover]:bg-white/[0.03]' : '' }}">
                {{ $slot }}
            </tbody>
        @endif
        @if(isset($footer))
            <tfoot class="border-t border-white/5 bg-white/[0.02]">
                {{ $footer }}
            </tfoot>
        @endif
    </table>
</div>

