@props([
    'sortable' => false,
    'sorted' => false,
    'direction' => 'asc',
])

<th {{ $attributes->merge([
    'class' => 'px-5 py-4 text-left text-xs font-semibold uppercase tracking-wider text-slate-400'
]) }}>
    @if($sortable)
        <button class="flex items-center gap-1.5 transition-colors hover:text-white">
            {{ $slot }}
            @if($sorted)
                @if($direction === 'asc')
                    <i class="ph-bold ph-caret-up text-[10px] text-indigo-400"></i>
                @else
                    <i class="ph-bold ph-caret-down text-[10px] text-indigo-400"></i>
                @endif
            @else
                <i class="ph-bold ph-arrows-down-up text-[10px]"></i>
            @endif
        </button>
    @else
        {{ $slot }}
    @endif
</th>

