@props([
    'tabs' => [],
    'activeTab' => null,
    'iconOnly' => false,
])

<div
    x-data="{
        activeTab: @js($activeTab ?? (count($tabs) > 0 ? array_key_first($tabs) : null)),
        scrollToActiveTab() {
            this.$nextTick(() => {
                const activeEl = this.$refs.tabNav?.querySelector('[data-active=true]');
                if (activeEl) {
                    activeEl.scrollIntoView({ behavior: 'smooth', block: 'nearest', inline: 'center' });
                }
            });
        }
    }"
    x-init="scrollToActiveTab()"
    {{ $attributes }}
>
    <!-- Tab Navigation with horizontal scroll on mobile -->
    <div class="relative border-b border-white/5">
        {{-- Scroll fade indicators --}}
        <div class="pointer-events-none absolute left-0 top-0 bottom-0 w-6 bg-gradient-to-r from-[#12121a] to-transparent z-10 sm:hidden"></div>
        <div class="pointer-events-none absolute right-0 top-0 bottom-0 w-6 bg-gradient-to-l from-[#12121a] to-transparent z-10 sm:hidden"></div>

        <nav
            x-ref="tabNav"
            class="-mb-px flex gap-1 sm:gap-6 overflow-x-auto scrollbar-none scroll-smooth snap-x snap-mandatory px-1 sm:px-0"
            aria-label="Tabs"
        >
            @foreach($tabs as $key => $tab)
                <button
                    @click="activeTab = '{{ $key }}'; scrollToActiveTab()"
                    :class="activeTab === '{{ $key }}'
                        ? 'border-indigo-500 text-white bg-indigo-500/10 sm:bg-transparent'
                        : 'border-transparent text-slate-500 hover:border-white/20 hover:text-slate-300'"
                    :data-active="activeTab === '{{ $key }}'"
                    class="whitespace-nowrap border-b-2 px-3 sm:px-1 py-3 text-xs sm:text-sm font-medium transition-all snap-center rounded-t-lg sm:rounded-none min-w-max shrink-0 flex items-center gap-2 active:scale-[0.98]"
                    type="button"
                >
                    @if(is_array($tab))
                        @if(isset($tab['icon']))
                            <i class="ph-duotone {{ $tab['icon'] }} text-base sm:text-lg"></i>
                        @endif
                        <span class="{{ $iconOnly ? 'hidden sm:inline' : '' }}">{{ $tab['label'] ?? $tab }}</span>
                        @if(isset($tab['count']))
                            <span
                                :class="activeTab === '{{ $key }}' ? 'bg-indigo-500/15 text-indigo-400' : 'bg-white/5 text-slate-400'"
                                class="rounded-full px-1.5 sm:px-2 py-0.5 text-[10px] sm:text-xs font-medium"
                            >{{ $tab['count'] }}</span>
                        @endif
                    @else
                        {{ $tab }}
                    @endif
                </button>
            @endforeach
        </nav>
    </div>

    <!-- Tab Content -->
    <div class="mt-4 sm:mt-6">
        {{ $slot }}
    </div>
</div>

