@props([
    'label' => null,
    'name' => null,
    'id' => null,
    'placeholder' => null,
    'helper' => null,
    'error' => null,
    'required' => false,
    'disabled' => false,
    'rows' => 4,
    'maxLength' => null,
    'autoResize' => false,
])

@php
    $inputId = $id ?? $name ?? uniqid('textarea_');
    $hasError = $error || (isset($errors) && $name && $errors->has($name));
    $errorMessage = $error ?? ($name ? $errors->first($name) : null);
    $hasWireModel = $attributes->whereStartsWith('wire:model')->isNotEmpty();
@endphp

<div
    {{ $attributes->only('class')->merge(['class' => 'space-y-1.5 sm:space-y-2']) }}
    @if($autoResize || $maxLength)
        x-data="{
            content: '',
            @if($maxLength) maxLength: {{ $maxLength }}, @endif
            @if($autoResize)
            resize() {
                this.$refs.textarea.style.height = 'auto';
                this.$refs.textarea.style.height = this.$refs.textarea.scrollHeight + 'px';
            }
            @endif
        }"
    @endif
>
    @if($label)
        <div class="flex items-center justify-between gap-2">
            <label for="{{ $inputId }}" class="block text-xs sm:text-sm font-medium text-slate-300 {{ $required ? 'after:ml-0.5 after:text-rose-400 after:content-[\'*\']' : '' }}">
                {{ $label }}
            </label>
            @if($maxLength)
                <span class="text-xs text-slate-500" x-text="`${content.length}/{{ $maxLength }}`"></span>
            @endif
        </div>
    @endif

    <textarea
        id="{{ $inputId }}"
        @if($name) name="{{ $name }}" @endif
        @if($name && !$hasWireModel) wire:model="{{ $name }}" @endif
        @if($placeholder) placeholder="{{ $placeholder }}" @endif
        @if($maxLength) maxlength="{{ $maxLength }}" x-model="content" @endif
        @if($autoResize) x-ref="textarea" x-init="resize()" @input="resize()" @endif
        rows="{{ $rows }}"
        class="block w-full rounded-lg sm:rounded-xl border border-white/10 bg-white/5 px-3 sm:px-4 py-3 text-base sm:text-sm text-white placeholder-slate-500 transition-all focus:border-indigo-500/50 focus:bg-white/10 focus:outline-none focus:ring-2 focus:ring-indigo-500/20 disabled:cursor-not-allowed disabled:opacity-50 {{ $autoResize ? 'resize-none overflow-hidden min-h-[100px]' : 'resize-y min-h-[80px]' }} {{ $hasError ? 'border-rose-500/50 focus:border-rose-500/50 focus:ring-rose-500/20' : '' }}"
        @if($required) required @endif
        @if($disabled) disabled @endif
        {{ $attributes->except('class') }}
    >{{ $slot }}</textarea>

    @if($helper && !$hasError)
        <p class="text-xs sm:text-sm text-slate-500">{{ $helper }}</p>
    @endif

    @if($hasError)
        <p class="flex items-center gap-1.5 text-xs sm:text-sm text-rose-400">
            <i class="ph-bold ph-warning-circle shrink-0"></i>
            {{ $errorMessage }}
        </p>
    @endif
</div>

