@props([
    'icon' => 'ph-circle',
    'iconColor' => 'primary',
    'title' => '',
    'time' => null,
    'description' => null,
    'compact' => false
])

@php
    $iconColors = [
        'primary' => 'bg-indigo-500/20 text-indigo-400',
        'success' => 'bg-emerald-500/20 text-emerald-400',
        'warning' => 'bg-amber-500/20 text-amber-400',
        'danger' => 'bg-rose-500/20 text-rose-400',
        'info' => 'bg-sky-500/20 text-sky-400',
        'neutral' => 'bg-slate-500/20 text-slate-400',
    ];

    $iconColorClass = $iconColors[$iconColor] ?? $iconColors['primary'];
@endphp

<div class="relative flex gap-3 sm:gap-4 pl-3 sm:pl-4">
    <!-- Icon -->
    <div @class([
        'absolute flex items-center justify-center rounded-full ring-4 ring-[#12121a]',
        $iconColorClass,
        'h-7 w-7 sm:h-9 sm:w-9 -left-0.5' => !$compact,
        'h-6 w-6 sm:h-7 sm:w-7 -left-0' => $compact,
    ])>
        <i @class([
            'ph-duotone',
            $icon,
            'text-sm sm:text-lg' => !$compact,
            'text-xs sm:text-sm' => $compact,
        ])></i>
    </div>

    <!-- Content -->
    <div @class([
        'flex-1 rounded-lg sm:rounded-xl bg-white/5 border border-white/5',
        'ml-6 sm:ml-8 p-3 sm:p-4' => !$compact,
        'ml-5 sm:ml-6 p-2.5 sm:p-3' => $compact,
    ])>
        <div class="flex flex-col sm:flex-row sm:items-start sm:justify-between gap-1 sm:gap-4">
            <div class="min-w-0 flex-1">
                <p @class([
                    'font-medium text-white truncate',
                    'text-sm sm:text-base' => !$compact,
                    'text-xs sm:text-sm' => $compact,
                ])>{{ $title }}</p>
                @if($description)
                    <p @class([
                        'mt-0.5 sm:mt-1 text-slate-400 line-clamp-2',
                        'text-xs sm:text-sm' => !$compact,
                        'text-xs' => $compact,
                    ])>{{ $description }}</p>
                @endif
            </div>
            @if($time)
                <span @class([
                    'shrink-0 text-slate-500',
                    'text-[10px] sm:text-xs' => !$compact,
                    'text-[10px]' => $compact,
                ])>{{ $time }}</span>
            @endif
        </div>

        @if($slot->isNotEmpty())
            <div class="mt-2 sm:mt-3">
                {{ $slot }}
            </div>
        @endif
    </div>
</div>

