<!-- Toast Container - Mobile Optimized -->
<div
    x-data="{
        toasts: [],
        add(toast) {
            const id = Date.now();
            // Support both 'title' and 'message' formats
            const normalizedToast = {
                id,
                type: toast.type || 'info',
                title: toast.title || toast.message || '',
                message: toast.title ? toast.message : null,
                duration: toast.duration || 5000,
                action: toast.action || null
            };
            this.toasts.push(normalizedToast);
            setTimeout(() => this.remove(id), normalizedToast.duration);
        },
        remove(id) {
            this.toasts = this.toasts.filter(t => t.id !== id);
        },
        swipeRemove(id, e) {
            if (Math.abs(e.detail.deltaX) > 100) {
                this.remove(id);
            }
        }
    }"
    @toast.window="add($event.detail)"
    class="pointer-events-none fixed inset-x-0 bottom-0 sm:bottom-4 sm:right-4 sm:left-auto z-[100] flex flex-col gap-2 sm:gap-3 p-4 sm:p-0"
>
    <template x-for="toast in toasts" :key="toast.id">
        <div
            x-show="true"
            x-transition:enter="transition ease-out duration-300"
            x-transition:enter-start="opacity-0 translate-y-4 sm:translate-y-2 scale-95"
            x-transition:enter-end="opacity-100 translate-y-0 scale-100"
            x-transition:leave="transition ease-in duration-200"
            x-transition:leave-start="opacity-100 translate-y-0 scale-100"
            x-transition:leave-end="opacity-0 translate-y-4 sm:translate-y-2 scale-95"
            x-on:swipe.right="swipeRemove(toast.id, $event)"
            x-on:swipe.left="swipeRemove(toast.id, $event)"
            class="pointer-events-auto flex w-full sm:w-80 items-start gap-3 rounded-xl border border-white/10 bg-[#12121a] p-3 sm:p-4 shadow-2xl shadow-black/50"
            :class="{
                'border-emerald-500/30': toast.type === 'success',
                'border-rose-500/30': toast.type === 'error',
                'border-amber-500/30': toast.type === 'warning',
                'border-sky-500/30': toast.type === 'info' || !toast.type
            }"
        >
            <div
                class="flex h-8 w-8 sm:h-8 sm:w-8 shrink-0 items-center justify-center rounded-full"
                :class="{
                    'bg-emerald-500/20 text-emerald-400': toast.type === 'success',
                    'bg-rose-500/20 text-rose-400': toast.type === 'error',
                    'bg-amber-500/20 text-amber-400': toast.type === 'warning',
                    'bg-sky-500/20 text-sky-400': toast.type === 'info' || !toast.type
                }"
            >
                <i
                    class="ph-duotone text-lg"
                    :class="{
                        'ph-check-circle': toast.type === 'success',
                        'ph-x-circle': toast.type === 'error',
                        'ph-warning': toast.type === 'warning',
                        'ph-info': toast.type === 'info' || !toast.type
                    }"
                ></i>
            </div>

            <div class="min-w-0 flex-1">
                <p class="text-xs sm:text-sm font-semibold text-white" x-text="toast.title"></p>
                <p x-show="toast.message" class="mt-0.5 text-xs sm:text-sm text-slate-400" x-text="toast.message"></p>

                {{-- Action Button (e.g., Undo) --}}
                <template x-if="toast.action">
                    <button
                        @click="toast.action.callback ? toast.action.callback() : (toast.action.url ? window.location.href = toast.action.url : null); remove(toast.id)"
                        class="mt-2 text-xs font-medium text-indigo-400 hover:text-indigo-300 transition-colors"
                        x-text="toast.action.label"
                    ></button>
                </template>
            </div>

            <button
                @click="remove(toast.id)"
                class="shrink-0 rounded-lg p-1.5 sm:p-1 text-slate-500 transition-colors hover:bg-white/10 hover:text-white min-h-8 min-w-8 sm:min-h-0 sm:min-w-0 flex items-center justify-center"
            >
                <i class="ph-bold ph-x text-sm"></i>
            </button>
        </div>
    </template>
</div>

