@props([
    'label' => null,
    'id' => null,
    'checked' => false,
    'disabled' => false,
    'helper' => null,
    'value' => '1'
])

@php
    $inputId = $id ?? uniqid('toggle_');
    $hasWireModel = $attributes->whereStartsWith('wire:model')->isNotEmpty();
@endphp

<label class="inline-flex items-center gap-3 {{ $disabled ? 'cursor-not-allowed opacity-50' : 'cursor-pointer' }}">
    <div class="relative">
        <input
            type="checkbox"
            id="{{ $inputId }}"
            value="{{ $value }}"
            class="peer sr-only"
            @if(!$hasWireModel) @checked($checked) @endif
            @disabled($disabled)
            {{ $attributes->except(['class']) }}
        >
        <div class="h-6 w-11 rounded-full bg-white/10 transition-colors peer-checked:bg-indigo-500 peer-focus:ring-2 peer-focus:ring-indigo-500/20"></div>
        <div class="absolute left-0.5 top-0.5 h-5 w-5 rounded-full bg-slate-400 shadow-sm transition-all peer-checked:translate-x-5 peer-checked:bg-white"></div>
    </div>

    @if($label)
        <span class="text-sm font-medium text-slate-300">
            {{ $label }}
            @if($helper)
                <span class="block text-xs text-slate-500">{{ $helper }}</span>
            @endif
        </span>
    @endif
</label>

