@props([
    'feature' => null,
    'tier' => null,
    'title' => 'Upgrade Required',
    'description' => null,
    'compact' => false,
])

@php
    $requiredTier = $tier ?? \App\Helpers\LicenseHelper::requiredTierFor($feature);
    $tierLabels = [
        'starter' => 'Starter',
        'professional' => 'Professional',
        'enterprise' => 'Enterprise',
    ];
    $tierLabel = $tierLabels[$requiredTier] ?? ucfirst($requiredTier);
@endphp

@if($compact)
    <div {{ $attributes->merge(['class' => 'inline-flex items-center gap-2 px-3 py-1.5 bg-amber-500/10 border border-amber-500/30 rounded-lg']) }}>
        <i class="ph-duotone ph-lock text-lg text-amber-400"></i>
        <span class="text-sm text-amber-400">{{ $tierLabel }} Plan</span>
        <a href="https://salieno.com/pricing" target="_blank" class="text-sm text-primary-400 hover:underline">
            Upgrade
        </a>
    </div>
@else
    <div {{ $attributes->merge(['class' => 'bg-gray-900 border border-gray-800 rounded-2xl p-6']) }}>
        <div class="flex items-start gap-4">
            <div class="w-12 h-12 bg-amber-500/20 rounded-xl flex items-center justify-center shrink-0">
                <i class="ph-duotone ph-lock text-2xl text-amber-400"></i>
            </div>
            <div class="flex-1">
                <h3 class="text-lg font-semibold text-white">{{ $title }}</h3>
                <p class="text-gray-400 mt-1">
                    {{ $description ?? "This feature requires the {$tierLabel} plan or higher." }}
                </p>

                @if($feature)
                    <p class="text-sm text-gray-500 mt-2">
                        Feature: <span class="text-gray-400">{{ ucwords(str_replace('_', ' ', $feature)) }}</span>
                    </p>
                @endif

                <div class="mt-4 flex gap-3">
                    <a href="https://salieno.com/pricing" target="_blank" class="inline-flex items-center gap-2 px-4 py-2 bg-primary-600 hover:bg-primary-700 text-white font-medium rounded-xl transition-colors">
                        <i class="ph-duotone ph-arrow-circle-up text-lg"></i>
                        Upgrade to {{ $tierLabel }}
                    </a>
                    <a href="https://salieno.com/features" target="_blank" class="inline-flex items-center gap-2 px-4 py-2 bg-gray-800 hover:bg-gray-700 text-gray-300 font-medium rounded-xl transition-colors">
                        Compare Plans
                    </a>
                </div>
            </div>
        </div>
    </div>
@endif

