@props([
    'type' => 'info', // info, success, warning, danger, primary
    'title' => null,
    'dismissible' => false,
    'icon' => null,
    'autoDismiss' => null,
    'compact' => false,
    'inline' => false,
])

@php
    $typeConfig = match($type) {
        'success' => ['class' => 'alert-success', 'iconBg' => 'bg-success', 'iconText' => 'text-success-color', 'icon' => 'ph-check-circle'],
        'warning' => ['class' => 'alert-warning', 'iconBg' => 'bg-warning', 'iconText' => 'text-warning-color', 'icon' => 'ph-warning'],
        'danger' => ['class' => 'alert-danger', 'iconBg' => 'bg-danger', 'iconText' => 'text-danger-color', 'icon' => 'ph-x-circle'],
        'primary' => ['class' => 'alert-primary', 'iconBg' => 'bg-primary', 'iconText' => 'text-primary-color', 'icon' => 'ph-lightbulb'],
        default => ['class' => 'alert-info', 'iconBg' => 'bg-info', 'iconText' => 'text-info-color', 'icon' => 'ph-info'],
    };

    $iconClass = $icon ?? $typeConfig['icon'];
    $padding = $compact ? 'p-3' : 'p-4';
@endphp

<div
    x-data="{ show: true, progress: 100, autoDismiss: {{ $autoDismiss ?? 'null' }}, init() { if (this.autoDismiss) { const step = 100 / (this.autoDismiss * 20); const interval = setInterval(() => { this.progress -= step; if (this.progress <= 0) { clearInterval(interval); this.show = false; } }, 50); } } }"
    x-show="show"
    x-transition:enter="transition ease-out duration-200"
    x-transition:enter-start="opacity-0 -translate-y-1"
    x-transition:enter-end="opacity-100 translate-y-0"
    x-transition:leave="transition ease-in duration-150"
    x-transition:leave-start="opacity-100"
    x-transition:leave-end="opacity-0"
    {{ $attributes->merge(['class' => "alert rounded-xl relative overflow-hidden $padding {$typeConfig['class']}"]) }}
>
    @if($autoDismiss)
        <div class="absolute bottom-0 left-0 h-0.5 transition-all {{ $typeConfig['iconBg'] }} opacity-50" :style="'width: ' + progress + '%'"></div>
    @endif

    <div class="flex gap-3">
        @if(!$inline)
            <div class="shrink-0">
                <div class="flex h-9 w-9 items-center justify-center rounded-lg {{ $typeConfig['iconBg'] }}">
                    <i class="ph {{ $iconClass }} text-lg text-white"></i>
                </div>
            </div>
        @else
            <div class="shrink-0 mt-0.5">
                <i class="ph {{ $iconClass }} text-lg {{ $typeConfig['iconText'] }}"></i>
            </div>
        @endif

        <div class="flex-1 min-w-0">
            @if($title)
                <h3 class="text-sm font-semibold text-dynamic">{{ $title }}</h3>
            @endif
            <div class="text-sm {{ $title ? 'mt-1' : '' }} text-dynamic-secondary">{{ $slot }}</div>
            @if(isset($actions))
                <div class="mt-3 flex flex-wrap gap-2">{{ $actions }}</div>
            @endif
        </div>

        @if($dismissible)
            <div class="shrink-0">
                <button @click="show = false" class="flex h-7 w-7 items-center justify-center rounded-md text-dynamic-muted hover:bg-card-hover transition-colors">
                    <i class="ph ph-x text-sm"></i>
                </button>
            </div>
        @endif
    </div>
</div>
