@props([
    'type' => 'default', // default, success, warning, danger, info, primary, secondary
    'size' => 'md', // xs, sm, md, lg
    'dot' => false,
    'pulse' => false,
    'icon' => null,
    'solid' => false,
    'count' => null,
    'maxCount' => 99,
    'outline' => false,
])

@php
    $baseClasses = 'badge inline-flex items-center gap-1 font-medium rounded-full whitespace-nowrap';

    $sizeClasses = match($size) {
        'xs' => 'px-1.5 py-0.5 text-[10px]',
        'sm' => 'px-2 py-0.5 text-[11px]',
        'lg' => 'px-3.5 py-1.5 text-sm',
        default => 'px-2.5 py-1 text-xs',
    };

    if ($count !== null) {
        $sizeClasses = match($size) {
            'xs' => 'min-w-4 h-4 px-1 text-[9px]',
            'sm' => 'min-w-[18px] h-[18px] px-1 text-[10px]',
            'lg' => 'min-w-6 h-6 px-1.5 text-xs',
            default => 'min-w-5 h-5 px-1 text-[11px]',
        };
        $baseClasses .= ' justify-center';
    }

    // Modern badge classes using CSS utility classes
    $typeClass = match($type) {
        'success' => $solid ? 'badge-solid-success' : ($outline ? 'border border-success text-success-color bg-transparent' : 'badge-success'),
        'warning' => $solid ? 'badge-solid-warning' : ($outline ? 'border border-warning text-warning-color bg-transparent' : 'badge-warning'),
        'danger' => $solid ? 'badge-solid-danger' : ($outline ? 'border border-danger text-danger-color bg-transparent' : 'badge-danger'),
        'info' => $solid ? 'badge-solid-info' : ($outline ? 'border border-info text-info-color bg-transparent' : 'badge-info'),
        'primary' => $solid ? 'badge-solid-primary' : ($outline ? 'border border-primary text-primary-color bg-transparent' : 'badge-primary'),
        'secondary' => $solid ? 'badge-solid-secondary' : ($outline ? 'border border-subtle text-dynamic-secondary bg-transparent' : 'badge-secondary'),
        default => 'badge-secondary',
    };

    $dotClass = match($type) {
        'success' => 'bg-success',
        'warning' => 'bg-warning',
        'danger' => 'bg-danger',
        'info' => 'bg-info',
        'primary' => 'bg-primary',
        'secondary' => 'bg-secondary',
        default => 'bg-dynamic-muted',
    };

    $displayCount = $count !== null ? ($count > $maxCount ? $maxCount . '+' : $count) : null;
@endphp

<span {{ $attributes->merge(['class' => "$baseClasses $sizeClasses $typeClass"]) }}>
    @if($dot)
        <span class="relative flex h-1.5 w-1.5">
            @if($pulse)
                <span class="absolute inline-flex h-full w-full animate-ping rounded-full opacity-75 {{ $dotClass }}"></span>
            @endif
            <span class="relative inline-flex h-1.5 w-1.5 rounded-full {{ $dotClass }}"></span>
        </span>
    @endif
    @if($icon)<i class="ph {{ $icon }}" style="font-size: 0.85em;"></i>@endif
    @if($count !== null){{ $displayCount }}@else{{ $slot }}@endif
</span>
