@props([
    'type' => 'button',
    'variant' => 'primary', // primary, secondary, success, danger, warning, ghost, outline, soft, outline-secondary
    'size' => 'md', // xs, sm, md, lg, xl
    'icon' => null,
    'iconPosition' => 'left',
    'iconOnly' => false,
    'loading' => false,
    'disabled' => false,
    'href' => null,
    'rounded' => 'lg', // sm, md, lg, xl, 2xl, full
    'fullWidth' => false,
    'wireLoading' => null,
])

@php
    $baseClasses = 'inline-flex items-center justify-center gap-2 font-medium focus:outline-none focus-ring disabled:opacity-50 disabled:cursor-not-allowed relative';

    // Modern sizing with touch-friendly defaults
    $sizeClasses = match($size) {
        'xs' => 'btn-xs',
        'sm' => 'btn-sm',
        'lg' => 'btn-lg',
        'xl' => 'btn-xl',
        default => '',
    };

    // Icon-only button sizing
    if ($iconOnly) {
        $sizeClasses = 'btn-icon';
    }

    $roundedClasses = match($rounded) {
        'sm' => 'rounded-sm',
        'md' => 'rounded-md',
        'xl' => 'rounded-xl',
        '2xl' => 'rounded-2xl',
        'full' => 'rounded-full',
        default => 'rounded-lg',
    };

    $widthClass = $fullWidth ? 'w-full' : '';

    // Modern variant classes using CSS variables
    $variantClass = match($variant) {
        'primary' => 'btn-primary',
        'secondary' => 'btn-secondary',
        'success' => 'btn-success',
        'danger' => 'btn-danger',
        'warning' => 'btn-warning',
        'info' => 'btn-info',
        'ghost' => 'btn-ghost',
        'outline' => 'btn-outline-primary',
        'outline-secondary' => 'btn-outline-secondary',
        'soft' => 'btn-soft',
        default => 'btn-primary',
    };

    $classes = trim("$baseClasses $variantClass $sizeClasses $roundedClasses $widthClass");
@endphp

@if($href)
    @php
        $isInternalLink = !str_starts_with($href, 'http') && !str_starts_with($href, '//');
    @endphp
    <a href="{{ $href }}" @if($isInternalLink) wire:navigate @endif {{ $attributes->merge(['class' => $classes]) }}>
        @if($loading)
            <span class="loading-spinner loading-spinner-sm"></span>
        @elseif($icon && $iconPosition === 'left')
            <i class="ph {{ $icon }}"></i>
        @endif
        @if(!$iconOnly)
            {{ $slot }}
        @endif
        @if($icon && $iconPosition === 'right' && !$loading)
            <i class="ph {{ $icon }}"></i>
        @endif
        @if($iconOnly && $icon && !$loading)
            <i class="ph {{ $icon }}"></i>
        @endif
    </a>
@else
    <button
        type="{{ $type }}"
        {{ $disabled || $loading ? 'disabled' : '' }}
        {{ $attributes->merge(['class' => $classes]) }}
        @if($wireLoading)
            wire:loading.class="btn-loading"
            wire:loading.attr="disabled"
            wire:target="{{ $wireLoading }}"
        @endif
    >
        @if($loading)
            <span class="loading-spinner loading-spinner-sm"></span>
        @elseif($icon && $iconPosition === 'left')
            <i class="ph {{ $icon }}"></i>
        @endif
        @if(!$iconOnly)
            {{ $slot }}
        @endif
        @if($icon && $iconPosition === 'right' && !$loading)
            <i class="ph {{ $icon }}"></i>
        @endif
        @if($iconOnly && $icon && !$loading)
            <i class="ph {{ $icon }}"></i>
        @endif
    </button>
@endif
