@props([
    'padding' => true,
    'hover' => false,
    'gradient' => null, // 'primary', 'success', 'warning', 'danger', 'info'
    'header' => null,
    'footer' => null,
    'loading' => false,
    'error' => false,
    'errorMessage' => null,
    'empty' => false,
    'emptyMessage' => null,
    'emptyIcon' => 'ph-folder-open',
    'size' => 'default', // 'compact', 'default', 'spacious'
    'interactive' => false,
    'glass' => false,
    'href' => null,
])

@php
    // Padding based on size
    $paddingClass = match($size) {
        'compact' => 'p-4',
        'spacious' => 'p-8',
        default => 'p-5 md:p-6'
    };

    // Header/Footer padding
    $headerPadding = match($size) {
        'compact' => 'px-4 py-3',
        'spacious' => 'px-8 py-5',
        default => 'px-5 py-4 md:px-6'
    };
    $footerPadding = $headerPadding;

    // Build classes using modern card system
    $cardClasses = 'card-dynamic animate-in';
    if ($hover) $cardClasses .= ' card-hover hover-lift';
    if ($interactive) $cardClasses .= ' card-interactive focus-ring';
    if ($gradient) $cardClasses .= ' border-primary-500/20'; // Standard border instead of gradient
    if ($error) $cardClasses .= ' ring-2 ring-red-200';
@endphp

@if($href)
<a href="{{ $href }}" {{ $attributes->merge(['class' => $cardClasses]) }}>
@else
<div {{ $attributes->merge(['class' => $cardClasses]) }} @if($interactive) tabindex="0" @endif>
@endif

    {{-- Header Section --}}
    @if($header)
        <div class="{{ $headerPadding }} border-b border-subtle">
            {{ $header }}
        </div>
    @endif

    {{-- Main Content --}}
    <div class="{{ $padding ? $paddingClass : '' }}">
        @if($loading)
            <div class="flex items-center justify-center py-8">
                <div class="flex flex-col items-center gap-3">
                    <div class="loading-spinner loading-spinner-lg"></div>
                    <span class="text-sm text-dynamic-muted">@lang('Loading...')</span>
                </div>
            </div>
        @elseif($error)
            <div class="flex items-center gap-4 py-4 px-1">
                <div class="flex h-12 w-12 shrink-0 items-center justify-center rounded-xl bg-danger-light">
                    <i class="ph ph-warning-circle text-xl text-danger-color"></i>
                </div>
                <div class="flex-1 min-w-0">
                    <p class="text-sm font-medium text-danger-color">@lang('Something went wrong')</p>
                    @if($errorMessage)
                        <p class="text-sm mt-1 text-dynamic-muted">{{ $errorMessage }}</p>
                    @endif
                </div>
            </div>
        @elseif($empty)
            <div class="flex flex-col items-center justify-center py-8 text-center">
                <div class="flex h-14 w-14 items-center justify-center rounded-2xl mb-4 bg-primary-light">
                    <i class="ph {{ $emptyIcon }} text-2xl text-primary-color"></i>
                </div>
                <p class="text-sm text-dynamic-muted">{{ $emptyMessage ?? __('No data available') }}</p>
            </div>
        @else
            {{ $slot }}
        @endif
    </div>

    {{-- Footer Section --}}
    @if($footer && !$loading && !$error && !$empty)
        <div class="{{ $footerPadding }} border-t border-subtle">
            {{ $footer }}
        </div>
    @endif

@if($href)
</a>
@else
</div>
@endif
