@props([
    'icon' => 'ph-folder-open',
    'title' => 'No data found',
    'description' => null,
    'actionText' => null,
    'actionHref' => null,
    'actionWireClick' => null,
    'actionIcon' => 'ph-plus',
    'secondaryActionText' => null,
    'secondaryActionHref' => null,
    'color' => 'primary',
    'illustration' => null,
    'size' => 'md',
    'compact' => false,
])

@php
    $colorConfig = match($color) {
        'primary' => ['bg' => 'bg-primary-light', 'text' => 'text-primary-color'],
        'success' => ['bg' => 'bg-success-light', 'text' => 'text-success-color'],
        'warning' => ['bg' => 'bg-warning-light', 'text' => 'text-warning-color'],
        'danger' => ['bg' => 'bg-danger-light', 'text' => 'text-danger-color'],
        'info' => ['bg' => 'bg-info-light', 'text' => 'text-info-color'],
        'secondary' => ['bg' => 'bg-subtle', 'text' => 'text-dynamic-muted'],
        default => ['bg' => 'bg-primary-light', 'text' => 'text-primary-color'],
    };

    $sizeClasses = match($size) {
        'sm' => 'py-6 px-4',
        'lg' => 'py-16 px-8',
        default => 'py-10 px-5',
    };

    $iconSize = match($size) {
        'sm' => 'h-14 w-14 text-2xl',
        'lg' => 'h-24 w-24 text-5xl',
        default => 'h-18 w-18 text-3xl',
    };

    $titleSize = match($size) {
        'sm' => 'text-base',
        'lg' => 'text-xl',
        default => 'text-lg',
    };

    $illustrations = [
        'services' => '<svg class="w-28 h-28" viewBox="0 0 200 200" fill="none"><rect x="40" y="60" width="120" height="80" rx="8" fill="var(--primary-light)" stroke="var(--primary)" stroke-width="2"/><rect x="50" y="75" width="40" height="8" rx="2" fill="var(--primary)" opacity="0.5"/><rect x="50" y="90" width="60" height="6" rx="2" fill="var(--primary)" opacity="0.3"/><circle cx="140" cy="100" r="15" fill="var(--primary)" opacity="0.2"/><path d="M135 100l4 4 8-8" stroke="var(--primary)" stroke-width="2" stroke-linecap="round"/></svg>',
        'invoices' => '<svg class="w-28 h-28" viewBox="0 0 200 200" fill="none"><rect x="50" y="40" width="100" height="130" rx="6" fill="var(--primary-light)" stroke="var(--primary)" stroke-width="2"/><rect x="65" y="60" width="50" height="8" rx="2" fill="var(--primary)" opacity="0.5"/><rect x="65" y="80" width="70" height="4" rx="1" fill="var(--primary)" opacity="0.3"/><rect x="65" y="92" width="60" height="4" rx="1" fill="var(--primary)" opacity="0.3"/><rect x="100" y="140" width="35" height="12" rx="2" fill="var(--primary)" opacity="0.4"/></svg>',
        'domains' => '<svg class="w-28 h-28" viewBox="0 0 200 200" fill="none"><circle cx="100" cy="100" r="60" fill="var(--primary-light)" stroke="var(--primary)" stroke-width="2"/><ellipse cx="100" cy="100" rx="25" ry="60" fill="none" stroke="var(--primary)" stroke-width="1.5" opacity="0.5"/><line x1="40" y1="100" x2="160" y2="100" stroke="var(--primary)" stroke-width="1.5" opacity="0.5"/></svg>',
        'tickets' => '<svg class="w-28 h-28" viewBox="0 0 200 200" fill="none"><rect x="40" y="50" width="120" height="100" rx="8" fill="var(--primary-light)" stroke="var(--primary)" stroke-width="2"/><circle cx="70" cy="85" r="15" fill="var(--primary)" opacity="0.3"/><rect x="95" y="78" width="50" height="6" rx="2" fill="var(--primary)" opacity="0.5"/><rect x="55" y="115" width="90" height="20" rx="4" fill="var(--primary)" opacity="0.15"/></svg>',
        'search' => '<svg class="w-28 h-28" viewBox="0 0 200 200" fill="none"><circle cx="90" cy="90" r="40" fill="var(--primary-light)" stroke="var(--primary)" stroke-width="2"/><line x1="120" y1="120" x2="150" y2="150" stroke="var(--primary)" stroke-width="4" stroke-linecap="round"/></svg>',
        'error' => '<svg class="w-28 h-28" viewBox="0 0 200 200" fill="none"><circle cx="100" cy="100" r="60" fill="var(--danger-light)" stroke="var(--danger)" stroke-width="2"/><path d="M100 70v40" stroke="var(--danger)" stroke-width="4" stroke-linecap="round"/><circle cx="100" cy="130" r="4" fill="var(--danger)"/></svg>',
        'cart' => '<svg class="w-28 h-28" viewBox="0 0 200 200" fill="none"><path d="M50 60h20l20 60h60l15-40H90" stroke="var(--primary)" stroke-width="2" fill="none"/><circle cx="95" cy="140" r="10" fill="var(--primary-light)" stroke="var(--primary)" stroke-width="2"/><circle cx="140" cy="140" r="10" fill="var(--primary-light)" stroke="var(--primary)" stroke-width="2"/></svg>',
    ];
@endphp

<div {{ $attributes->merge(['class' => "flex flex-col items-center justify-center text-center animate-in $sizeClasses"]) }}>
    @if($illustration && isset($illustrations[$illustration]))
        <div class="animate-float">{!! $illustrations[$illustration] !!}</div>
    @else
        <div class="flex items-center justify-center rounded-2xl {{ $iconSize }} {{ $colorConfig['bg'] }}">
            <i class="ph {{ $icon }} {{ $colorConfig['text'] }}"></i>
        </div>
    @endif

    <h3 class="mt-4 font-semibold {{ $titleSize }} text-dynamic">{{ __($title) }}</h3>

    @if($description)
        <p class="mt-2 max-w-sm text-sm text-dynamic-secondary">{{ __($description) }}</p>
    @endif

    @if($actionText || $secondaryActionText)
        <div class="mt-5 flex flex-col sm:flex-row items-center gap-3">
            @if($actionText && $actionHref)
                <x-client.button :href="$actionHref" :icon="$actionIcon">{{ __($actionText) }}</x-client.button>
            @elseif($actionText && $actionWireClick)
                <x-client.button wire:click="{{ $actionWireClick }}" :icon="$actionIcon">{{ __($actionText) }}</x-client.button>
            @endif
            @if($secondaryActionText && $secondaryActionHref)
                <x-client.button variant="ghost" :href="$secondaryActionHref">{{ __($secondaryActionText) }}</x-client.button>
            @endif
        </div>
    @endif

    {{ $slot }}
</div>
