@php
    $user = auth()->user();
    $navigation = [
        ['name' => 'Dashboard', 'route' => 'client.dashboard', 'icon' => 'ph-house'],
        ['name' => 'Services', 'route' => 'client.services.index', 'icon' => 'ph-cube'],
        ['name' => 'Domains', 'route' => 'client.domains.index', 'icon' => 'ph-globe'],
        ['name' => 'Invoices', 'route' => 'client.invoices.index', 'icon' => 'ph-receipt'],
        ['name' => 'Tickets', 'route' => 'client.tickets.index', 'icon' => 'ph-chat-circle-dots'],
    ];
@endphp

<header class="sticky top-0 z-40 backdrop-blur-xl border-subtle" style="background: var(--card-bg); border-bottom-width: 1px;">
    <div class="mx-auto max-w-7xl px-4 sm:px-6 lg:px-8">
        <div class="flex h-16 items-center justify-between">
            {{-- Logo --}}
            <div class="flex items-center gap-8">
                <a href="{{ route('client.dashboard') }}" class="flex items-center gap-3">
                    <div class="flex h-10 w-10 items-center justify-center rounded-xl bg-primary text-white shadow-lg">
                        <i class="ph-bold ph-lightning text-xl"></i>
                    </div>
                    <span class="hidden text-xl font-bold text-dynamic sm:block">{{ gs('site_name') ?? 'Salieno' }}</span>
                </a>

                {{-- Desktop Navigation --}}
                <nav class="hidden lg:flex lg:items-center lg:gap-1">
                    @foreach($navigation as $item)
                        @php $isActive = request()->routeIs($item['route'].'*'); @endphp
                        <a href="{{ route($item['route']) }}" class="nav-link {{ $isActive ? 'nav-link-active' : '' }}">
                            <i class="ph-duotone {{ $item['icon'] }} text-lg"></i>
                            {{ __($item['name']) }}
                        </a>
                    @endforeach
                </nav>
            </div>

            {{-- Right Side --}}
            <div class="flex items-center gap-3">
                {{-- Balance Badge --}}
                @if($user)
                    <div class="hidden items-center gap-2 rounded-full bg-success-light px-4 py-2 sm:flex">
                        <i class="ph-duotone ph-wallet text-lg text-success-color"></i>
                        <span class="text-sm font-semibold text-success-color">{{ showAmount($user->balance ?? 0) }}</span>
                    </div>
                @endif

                {{-- Notifications --}}
                <div class="relative" x-data="{ open: false }">
                    <button @click="open = !open" class="btn-icon relative">
                        <i class="ph-duotone ph-bell text-xl"></i>
                        <span class="absolute right-1 top-1 flex h-4 w-4 items-center justify-center rounded-full bg-danger text-2xs font-bold text-white">3</span>
                    </button>

                    <div x-show="open" @click.away="open = false"
                         x-transition:enter="transition ease-out duration-200"
                         x-transition:enter-start="opacity-0 scale-95"
                         x-transition:enter-end="opacity-100 scale-100"
                         x-transition:leave="transition ease-in duration-150"
                         x-transition:leave-start="opacity-100"
                         x-transition:leave-end="opacity-0 scale-95"
                         class="dropdown-menu absolute right-0 mt-2 w-80 origin-top-right" x-cloak>
                        <div class="px-3 py-2">
                            <h3 class="text-sm font-semibold text-dynamic">@lang('Notifications')</h3>
                        </div>
                        <div class="max-h-64 overflow-y-auto">
                            <p class="px-3 py-4 text-center text-sm text-dynamic-muted">@lang('No new notifications')</p>
                        </div>
                    </div>
                </div>

                {{-- User Menu --}}
                <div class="relative" x-data="{ open: false }">
                    <button @click="open = !open" class="flex items-center gap-3 rounded-full p-1.5 transition-colors hover:bg-subtle">
                        <div class="flex h-8 w-8 items-center justify-center rounded-full bg-primary text-sm font-semibold text-white">
                            {{ strtoupper(substr($user->firstname ?? 'U', 0, 1)) }}{{ strtoupper(substr($user->lastname ?? '', 0, 1)) }}
                        </div>
                        <div class="hidden text-left sm:block">
                            <p class="text-sm font-medium text-dynamic">{{ $user->firstname ?? 'User' }} {{ $user->lastname ?? '' }}</p>
                            <p class="text-xs text-dynamic-muted">{{ $user->email ?? '' }}</p>
                        </div>
                        <i class="ph ph-caret-down hidden text-dynamic-muted sm:block"></i>
                    </button>

                    <div x-show="open" @click.away="open = false"
                         x-transition:enter="transition ease-out duration-200"
                         x-transition:enter-start="opacity-0 scale-95"
                         x-transition:enter-end="opacity-100 scale-100"
                         x-transition:leave="transition ease-in duration-150"
                         x-transition:leave-start="opacity-100"
                         x-transition:leave-end="opacity-0 scale-95"
                         class="dropdown-menu absolute right-0 mt-2 w-56 origin-top-right" x-cloak>
                        <a href="{{ route('client.profile.index') }}" class="dropdown-item">
                            <i class="ph-duotone ph-user-circle text-lg"></i>
                            @lang('Profile Settings')
                        </a>
                        <a href="{{ route('client.profile.security') }}" class="dropdown-item">
                            <i class="ph-duotone ph-shield-check text-lg"></i>
                            @lang('Security')
                        </a>
                        <a href="{{ route('client.transactions.index') }}" class="dropdown-item">
                            <i class="ph-duotone ph-clock-counter-clockwise text-lg"></i>
                            @lang('Transactions')
                        </a>
                        <div class="my-2 divider"></div>
                        <form method="POST" action="{{ route('client.logout') }}">
                            @csrf
                            <button type="submit" class="dropdown-item text-danger-color w-full">
                                <i class="ph-duotone ph-sign-out text-lg"></i>
                                @lang('Sign Out')
                            </button>
                        </form>
                    </div>
                </div>

                {{-- Mobile Menu Button --}}
                <button @click="mobileMenuOpen = !mobileMenuOpen" class="btn-icon lg:hidden">
                    <i class="ph-bold ph-list text-xl"></i>
                </button>
            </div>
        </div>
    </div>
</header>

