@php
    $impersonation = session('impersonating');
@endphp

@if($impersonation)
    <div class="fixed inset-x-0 top-0 z-[100] bg-gradient-to-r from-amber-500 via-orange-500 to-amber-500 px-4 py-2.5 text-white shadow-lg">
        <div class="mx-auto flex max-w-7xl items-center justify-between gap-4">
            <div class="flex items-center gap-3">
                <div class="flex h-8 w-8 items-center justify-center rounded-full bg-white/20 backdrop-blur-sm">
                    <i class="ph-duotone ph-user-switch text-lg"></i>
                </div>
                <div class="flex flex-col sm:flex-row sm:items-center sm:gap-2">
                    <span class="text-sm font-medium">
                        @lang('Viewing as')
                        <strong class="ml-1">{{ $impersonation['user_name'] }}</strong>
                    </span>
                    <span class="hidden text-xs text-amber-100 sm:inline">
                        &bull; @lang('Logged in as') {{ $impersonation['admin_name'] }}
                    </span>
                </div>
            </div>
            <a
                href="{{ route('admin.impersonation.stop') }}"
                class="inline-flex items-center gap-2 rounded-lg bg-white/20 px-4 py-1.5 text-sm font-semibold text-white backdrop-blur-sm transition-all hover:bg-white/30 hover:shadow-md"
            >
                <i class="ph-bold ph-sign-out text-base"></i>
                <span class="hidden sm:inline">@lang('Exit to Admin')</span>
                <span class="sm:hidden">@lang('Exit')</span>
            </a>
        </div>
    </div>
    
    {{-- Spacer to push content down --}}
    <div class="h-12"></div>
@endif

