@props([
    'type' => 'text',
    'label' => null,
    'placeholder' => '',
    'error' => null,
    'success' => null,
    'hint' => null,
    'icon' => null,
    'iconPosition' => 'left',
    'required' => false,
    'disabled' => false,
    'readonly' => false,
    'size' => 'md', // sm, md, lg
    'maxlength' => null,
    'showCounter' => false,
    'clearable' => false,
    'prefix' => null,
    'suffix' => null,
    'rows' => 4, // For textarea
])

@php
    // Size classes - modern sizing
    $sizeClasses = match($size) {
        'sm' => 'py-2 text-xs',
        'lg' => 'py-3.5 text-base',
        default => 'py-2.5 text-sm',
    };

    // Padding based on icon/prefix/suffix
    $leftPadding = ($icon && $iconPosition === 'left') || $prefix ? 'pl-10' : 'pl-3.5';
    $rightPadding = ($icon && $iconPosition === 'right') || $suffix || ($type === 'password') || $clearable || $success ? 'pr-10' : 'pr-3.5';

    // State classes
    $stateClass = $error ? 'input-error' : ($success ? 'input-success' : '');

    // Determine element type
    $isSelect = $type === 'select';
    $isTextarea = $type === 'textarea';
    $isInput = !$isSelect && !$isTextarea;
@endphp

<div
    x-data="{ showPassword: false, value: '', init() { this.value = this.$refs.input?.value || this.$refs.select?.value || this.$refs.textarea?.value || ''; } }"
    {{ $attributes->only('class')->merge(['class' => 'space-y-1.5']) }}
>
    @if($label)
        <label class="block text-sm font-medium text-dynamic">
            {{ __($label) }}
            @if($required)<span class="text-danger-color ml-0.5">*</span>@endif
        </label>
    @endif

    <div class="relative">
        {{-- Left Icon or Prefix (not for select/textarea) --}}
        @if($isInput && (($icon && $iconPosition === 'left') || $prefix))
            @if($icon && $iconPosition === 'left')
                <div class="pointer-events-none absolute inset-y-0 left-0 flex items-center pl-3">
                    <i class="{{ str_contains($icon, 'ph') ? $icon : 'ph ' . $icon }} text-base text-dynamic-muted"></i>
                </div>
            @elseif($prefix)
                <div class="pointer-events-none absolute inset-y-0 left-0 flex items-center pl-3">
                    <span class="text-sm text-dynamic-muted">{{ $prefix }}</span>
                </div>
            @endif
        @endif

        {{-- SELECT Element --}}
        @if($isSelect)
            <select
                x-ref="select"
                {{ $disabled ? 'disabled' : '' }}
                {{ $required ? 'required' : '' }}
                @change="value = $event.target.value"
                class="input-dynamic block w-full rounded-lg {{ $sizeClasses }} pl-3.5 pr-10 {{ $stateClass }} appearance-none cursor-pointer"
                {{ $attributes->except('class') }}
            >
                {{ $slot }}
            </select>
            {{-- Select Arrow --}}
            <div class="pointer-events-none absolute inset-y-0 right-0 flex items-center pr-3">
                <i class="ph ph-caret-down text-sm text-dynamic-muted"></i>
            </div>

        {{-- TEXTAREA Element --}}
        @elseif($isTextarea)
            <textarea
                x-ref="textarea"
                placeholder="{{ $placeholder }}"
                {{ $disabled ? 'disabled' : '' }}
                {{ $readonly ? 'readonly' : '' }}
                {{ $required ? 'required' : '' }}
                rows="{{ $rows }}"
                @if($maxlength) maxlength="{{ $maxlength }}" @endif
                @input="value = $event.target.value"
                class="input-dynamic block w-full rounded-lg {{ $sizeClasses }} px-3.5 {{ $stateClass }} resize-y min-h-20"
                {{ $attributes->except('class') }}
            >{{ $slot }}</textarea>

        {{-- INPUT Element --}}
        @else
            <input
                x-ref="input"
                :type="@if($type === 'password') showPassword ? 'text' : 'password' @else '{{ $type }}' @endif"
                placeholder="{{ $placeholder }}"
                {{ $disabled ? 'disabled' : '' }}
                {{ $readonly ? 'readonly' : '' }}
                {{ $required ? 'required' : '' }}
                @if($maxlength) maxlength="{{ $maxlength }}" @endif
                @input="value = $event.target.value"
                class="input-dynamic block w-full rounded-lg {{ $sizeClasses }} {{ $leftPadding }} {{ $rightPadding }} {{ $stateClass }}"
                {{ $attributes->except('class') }}
            />

            {{-- Right Icons (only for input) --}}
            <div class="absolute inset-y-0 right-0 flex items-center gap-1 pr-2.5">
                @if($success)
                    <div class="flex items-center justify-center w-5 h-5 rounded-full bg-success-light">
                        <i class="ph ph-check text-xs text-success-color"></i>
                    </div>
                @endif

                @if($clearable)
                    <button type="button" x-show="value.length > 0" x-transition
                        @click="$refs.input.value = ''; value = ''; $refs.input.focus(); $refs.input.dispatchEvent(new Event('input', { bubbles: true }));"
                        class="flex items-center justify-center w-5 h-5 rounded-full text-dynamic-muted hover:bg-primary-light hover:text-primary-color transition-colors">
                        <i class="ph ph-x text-xs"></i>
                    </button>
                @endif

                @if($type === 'password')
                    <button type="button" @click="showPassword = !showPassword"
                        class="flex items-center justify-center w-7 h-7 rounded-md text-dynamic-muted hover:bg-primary-light hover:text-primary-color transition-colors">
                        <i class="ph text-base" :class="showPassword ? 'ph-eye-slash' : 'ph-eye'"></i>
                    </button>
                @endif

                @if($icon && $iconPosition === 'right')
                    <i class="{{ str_contains($icon, 'ph') ? $icon : 'ph ' . $icon }} text-base text-dynamic-muted"></i>
                @endif

                @if($suffix)
                    <span class="text-sm text-dynamic-muted">{{ $suffix }}</span>
                @endif
            </div>
        @endif
    </div>

    @if($maxlength && $showCounter && ($isInput || $isTextarea))
        <div class="flex justify-end">
            <span class="text-xs text-dynamic-muted"><span x-text="value.length">0</span> / {{ $maxlength }}</span>
        </div>
    @endif

    @if($error)
        <p class="flex items-center gap-1.5 text-xs text-danger-color animate-in">
            <i class="ph ph-warning-circle"></i>{{ $error }}
        </p>
    @elseif($success && is_string($success))
        <p class="flex items-center gap-1.5 text-xs text-success-color animate-in">
            <i class="ph ph-check-circle"></i>{{ $success }}
        </p>
    @elseif($hint)
        <p class="text-xs text-dynamic-muted">{{ $hint }}</p>
    @endif
</div>
