@php
    use App\Models\Language;

    $multiLanguageEnabled = gs('multi_language');
    $languages = $multiLanguageEnabled ? Language::all() : collect();
    $currentLang = $languages->where('code', session('lang', config('app.locale')))->first()
                   ?? $languages->where('is_default', true)->first()
                   ?? $languages->first();
@endphp

@if($multiLanguageEnabled && $languages->count() > 1)
<div x-data="{ langOpen: false }" class="relative">
    {{-- Trigger Button --}}
    @if(($variant ?? 'sidebar') === 'header')
    {{-- Header variant: Icon only --}}
    <button @click="langOpen = !langOpen"
            type="button"
            class="flex items-center justify-center p-2.5 rounded-xl transition-smooth"
            style="color: var(--text-muted);"
            @mouseenter="$el.style.backgroundColor='var(--primary-light)'; $el.style.color='var(--text-secondary)'"
            @mouseleave="$el.style.backgroundColor='transparent'; $el.style.color='var(--text-muted)'"
            title="{{ $currentLang->name ?? 'Language' }}"
    >
        @if($currentLang && $currentLang->image)
            <img src="{{ asset(getFilePath('language') . '/' . $currentLang->image) }}"
                 alt="{{ $currentLang->name }}"
                 class="w-5 h-5 rounded-sm object-cover" />
        @else
            <i class="ph ph-globe text-xl"></i>
        @endif
    </button>
    @else
    {{-- Sidebar/default variant: Icon + Name --}}
    <button @click="langOpen = !langOpen"
            type="button"
            class="flex items-center gap-2 px-3 py-2 rounded-xl transition-smooth"
            style="color: var(--sidebar-text, var(--text-secondary));"
            @mouseenter="$el.style.backgroundColor='var(--sidebar-hover-bg)'"
            @mouseleave="$el.style.backgroundColor='transparent'"
    >
        @if($currentLang && $currentLang->image)
            <img src="{{ asset(getFilePath('language') . '/' . $currentLang->image) }}"
                 alt="{{ $currentLang->name }}"
                 class="w-5 h-5 rounded-sm object-cover" />
        @else
            <i class="ph ph-globe text-lg"></i>
        @endif
        <span class="text-sm font-medium">{{ $currentLang->name ?? 'Language' }}</span>
        <i class="ph ph-caret-down text-xs transition-transform duration-200" :class="langOpen ? 'rotate-180' : ''"></i>
    </button>
    @endif

    {{-- Dropdown --}}
    <div x-show="langOpen"
         @click.away="langOpen = false"
         x-transition:enter="transition ease-out duration-200"
         x-transition:enter-start="opacity-0 translate-y-1"
         x-transition:enter-end="opacity-100 translate-y-0"
         x-transition:leave="transition ease-in duration-150"
         x-transition:leave-start="opacity-100 translate-y-0"
         x-transition:leave-end="opacity-0 translate-y-1"
         class="absolute {{ ($position ?? 'bottom') === 'top' ? 'bottom-full mb-2' : 'top-full mt-2' }} {{ ($align ?? 'left') === 'right' ? 'right-0' : 'left-0' }} w-48 rounded-xl shadow-xl overflow-hidden z-50"
         style="background-color: var(--card-bg); border: 1px solid var(--card-border);"
         x-cloak>
        <div class="px-4 py-3" style="border-bottom: 1px solid var(--card-border); background-color: var(--primary-light);">
            <p class="text-xs font-semibold uppercase tracking-wide" style="color: var(--text-muted);">@lang('Select Language')</p>
        </div>
        <div class="p-1.5 max-h-64 overflow-y-auto">
            @foreach($languages as $lang)
                <a href="{{ route('lang.change', $lang->code) }}"
                   class="flex items-center gap-3 px-3 py-2.5 rounded-lg transition-smooth {{ $currentLang && $currentLang->code === $lang->code ? 'font-medium' : '' }}"
                   style="{{ $currentLang && $currentLang->code === $lang->code ? 'background-color: var(--primary-light); color: var(--primary);' : 'color: var(--text-secondary);' }}"
                   @mouseenter="$el.style.backgroundColor='var(--primary-light)'"
                   @mouseleave="$el.style.backgroundColor='{{ $currentLang && $currentLang->code === $lang->code ? 'var(--primary-light)' : 'transparent' }}'">
                    @if($lang->image)
                        <img src="{{ asset(getFilePath('language') . '/' . $lang->image) }}"
                             alt="{{ $lang->name }}"
                             class="w-5 h-5 rounded-sm object-cover" />
                    @else
                        <i class="ph ph-flag text-lg" style="color: var(--text-muted);"></i>
                    @endif
                    <span class="text-sm">{{ $lang->name }}</span>
                    @if($currentLang && $currentLang->code === $lang->code)
                        <i class="ph-fill ph-check-circle text-sm ml-auto" style="color: var(--primary);"></i>
                    @endif
                </a>
            @endforeach
        </div>
    </div>
</div>
@endif

