{{-- General Logo Component - Multi-Purpose --}}
@props([
    'maxHeight' => 'max-h-24',
    'maxWidth' => 'max-w-[320px]',
    'containerClass' => '',
    'imageClass' => '',
    'variant' => 'responsive' // 'responsive', 'dark-bg', or 'light-bg'
])

@php
    $siteName = gs('site_name') ?? config('app.name', 'Salieno');
    $baseImageClasses = "{$maxHeight} h-auto w-auto {$maxWidth} object-contain object-left pointer-events-none select-none {$imageClass}";
    
    $lightLogo = siteLogo();
    $darkLogo = siteLogo('dark');
    
    // Check if we have real logos or just the default placeholder
    $hasRealLogo = !str_contains($lightLogo, 'default.png') || !str_contains($darkLogo, 'default.png');
@endphp

<div {{ $attributes->merge(['class' => "flex items-center $containerClass"]) }} x-cloak>
    @if($hasRealLogo)
        <div class="relative flex items-center">
            @if($variant === 'responsive')
                {{-- Theme-Reactive Logic --}}
                <img :src="$store.theme.on ? '{{ $darkLogo }}' : '{{ $lightLogo }}'" 
                     alt="{{ $siteName }}" 
                     class="{{ $baseImageClasses }}">
            @elseif($variant === 'dark-bg')
                {{-- Forced Light Assets for Dark Backgrounds --}}
                <img src="{{ $lightLogo }}" alt="{{ $siteName }}" class="{{ $baseImageClasses }}">
            @else
                {{-- Forced Dark Assets for Light Backgrounds --}}
                <img src="{{ $darkLogo }}" alt="{{ $siteName }}" class="{{ $baseImageClasses }}">
            @endif
        </div>
    @else
        {{-- Textual Fallback --}}
        <div class="flex items-center gap-2 font-bold text-xl tracking-tight text-dynamic">
            <div class="w-10 h-10 rounded-xl bg-primary-color flex items-center justify-center shadow-lg">
                <i class="ph-duotone ph-lightning text-xl text-white"></i>
            </div>
            <span>{{ $siteName }}</span>
        </div>
    @endif
</div>

