@php
    // Use dynamic navigation helpers for menu visibility
    $navigation = getClientNavigation();
    $accountNav = getAccountNavigation();
@endphp

<!-- Mobile Navigation Overlay -->
<div
    x-show="mobileMenuOpen"
    x-transition:enter="transition-opacity ease-linear duration-300"
    x-transition:enter-start="opacity-0"
    x-transition:enter-end="opacity-100"
    x-transition:leave="transition-opacity ease-linear duration-300"
    x-transition:leave-start="opacity-100"
    x-transition:leave-end="opacity-0"
    @click="mobileMenuOpen = false"
    class="fixed inset-0 z-40 bg-slate-900/60 backdrop-blur-sm lg:hidden"
    x-cloak
></div>

<!-- Mobile Navigation Panel - Friendly Design -->
<div
    x-show="mobileMenuOpen"
    x-transition:enter="transition ease-out duration-300"
    x-transition:enter-start="translate-x-full"
    x-transition:enter-end="translate-x-0"
    x-transition:leave="transition ease-in duration-200"
    x-transition:leave-start="translate-x-0"
    x-transition:leave-end="translate-x-full"
    class="fixed inset-y-0 right-0 z-50 w-full max-w-xs shadow-2xl lg:hidden"
    style="background: var(--card-bg);"
    x-cloak
>
    <div class="flex h-full flex-col">
        <!-- Header with User Info -->
        <div class="px-5 py-5" style="border-bottom: 1px solid var(--card-border);">
            <div class="flex items-center justify-between mb-4">
                <span class="text-lg font-semibold" style="color: var(--text-primary);">@lang('Menu')</span>
                <button
                    @click="mobileMenuOpen = false"
                    class="flex h-9 w-9 items-center justify-center rounded-xl transition-all hover:scale-105"
                    style="background: var(--bg-gradient-from); color: var(--text-muted);"
                >
                    <i class="ph-bold ph-x text-base"></i>
                </button>
            </div>

            <!-- User Card -->
            <div class="flex items-center gap-3 p-3 rounded-xl" style="background: var(--primary-light);">
                <div class="h-11 w-11 rounded-xl flex items-center justify-center text-white font-semibold" style="background: linear-gradient(135deg, var(--primary), var(--primary-hover));">
                    {{ strtoupper(substr(auth()->user()->name ?? 'U', 0, 1)) }}
                </div>
                <div class="flex-1 min-w-0">
                    <p class="text-sm font-semibold truncate" style="color: var(--text-primary);">{{ auth()->user()->name ?? 'User' }}</p>
                    <p class="text-xs" style="color: var(--text-muted);">{{ formatCurrency(auth()->user()->balance ?? 0) }}</p>
                </div>
            </div>
        </div>

        <!-- Navigation Links -->
        <nav class="flex-1 overflow-y-auto px-4 py-5">
            {{-- Main Navigation --}}
            <div class="space-y-1">
                @foreach($navigation as $item)
                    @php
                        $isActive = isset($item['exact']) && $item['exact']
                            ? request()->routeIs($item['route'])
                            : request()->routeIs($item['route'].'*');
                    @endphp
                    <a
                        href="{{ route($item['route']) }}"
                        class="flex items-center gap-3 rounded-xl px-4 py-3 text-sm font-medium transition-all duration-200"
                        style="{{ $isActive
                            ? 'background: var(--primary-light); color: var(--primary);'
                            : 'color: var(--text-secondary);' }}"
                    >
                        <i class="ph-duotone {{ $item['icon'] }} text-xl"></i>
                        {{ __($item['name']) }}
                    </a>
                @endforeach
            </div>

            {{-- Account Navigation --}}
            @if(count($accountNav) > 0)
            <div class="mt-6 pt-4" style="border-top: 1px solid var(--card-border);">
                <p class="px-4 mb-2 text-xs font-medium uppercase tracking-wider" style="color: var(--text-muted);">@lang('Account')</p>
                <div class="space-y-1">
                    @foreach($accountNav as $item)
                        @php $isActive = request()->routeIs($item['route'].'*'); @endphp
                        <a
                            href="{{ route($item['route']) }}"
                            class="flex items-center gap-3 rounded-xl px-4 py-3 text-sm font-medium transition-all duration-200"
                            style="{{ $isActive
                                ? 'background: var(--primary-light); color: var(--primary);'
                                : 'color: var(--text-secondary);' }}"
                        >
                            <i class="ph-duotone {{ $item['icon'] }} text-xl"></i>
                            {{ __($item['name']) }}
                        </a>
                    @endforeach
                </div>
            </div>
            @endif
        </nav>

        <!-- Footer -->
        <div class="p-4" style="border-top: 1px solid var(--card-border);">
            <form method="POST" action="{{ route('client.logout') }}">
                @csrf
                <button type="submit" class="flex w-full items-center justify-center gap-2 rounded-xl px-4 py-3 text-sm font-medium transition-all hover:scale-[1.02]" style="background: rgba(239,68,68,0.1); color: var(--danger);">
                    <i class="ph-duotone ph-sign-out text-lg"></i>
                    @lang('Sign Out')
                </button>
            </form>
        </div>
    </div>
</div>

