@props([
    'name' => null,
    'show' => null,
    'title' => null,
    'subtitle' => null,
    'icon' => null,
    'iconColor' => 'primary',
    'maxWidth' => 'md',
    'closeable' => true,
    'loading' => false,
    'mobileFullScreen' => false,
    'persistent' => false,
    'closeAction' => null,
])

@php
    $maxWidthClasses = match($maxWidth) {
        'sm' => 'sm:max-w-sm',
        'lg' => 'sm:max-w-lg',
        'xl' => 'sm:max-w-xl',
        '2xl' => 'sm:max-w-2xl',
        'full' => 'sm:max-w-4xl',
        default => 'sm:max-w-md',
    };

    $iconConfig = match($iconColor) {
        'success' => ['bg' => 'bg-success-light', 'text' => 'text-success-color'],
        'danger' => ['bg' => 'bg-danger-light', 'text' => 'text-danger-color'],
        'warning' => ['bg' => 'bg-warning-light', 'text' => 'text-warning-color'],
        'info' => ['bg' => 'bg-info-light', 'text' => 'text-info-color'],
        default => ['bg' => 'bg-primary-light', 'text' => 'text-primary-color'],
    };

    $mobileClasses = $mobileFullScreen ? 'max-sm:fixed max-sm:inset-0 max-sm:rounded-none max-sm:max-w-none max-sm:m-0' : '';
@endphp

@if($show)
<div
    x-data="{ loading: {{ $loading ? 'true' : 'false' }} }"
    class="fixed inset-0 overflow-y-auto"
    style="z-index: var(--z-modal);"
>
    {{-- Backdrop --}}
    <div class="modal-backdrop fixed inset-0 animate-in" style="animation-duration: 150ms;"></div>

    {{-- Modal Panel --}}
    <div class="modal-container flex min-h-full items-center justify-center p-4 {{ $mobileFullScreen ? 'max-sm:p-0' : '' }}">
        <div
            class="card-dynamic relative w-full transform overflow-hidden shadow-2xl animate-in {{ $maxWidthClasses }} {{ $mobileClasses }} {{ $mobileFullScreen ? 'max-sm:flex max-sm:flex-col max-sm:h-full' : '' }}"
            style="animation-duration: 200ms;"
            @click.stop
        >
            {{-- Loading Overlay --}}
            <div x-show="loading" x-transition class="absolute inset-0 flex items-center justify-center glass z-10">
                <div class="flex flex-col items-center gap-3">
                    <div class="loading-spinner loading-spinner-lg"></div>
                    <span class="text-sm text-dynamic-muted">@lang('Processing...')</span>
                </div>
            </div>

            {{-- Header --}}
            @if($title || $closeable)
                <div class="flex items-start justify-between px-5 py-4 shrink-0 border-b border-subtle">
                    <div class="flex items-center gap-3">
                        @if($icon)
                            <div class="flex h-10 w-10 items-center justify-center rounded-xl {{ $iconConfig['bg'] }}">
                                <i class="ph {{ $icon }} text-lg {{ $iconConfig['text'] }}"></i>
                            </div>
                        @endif
                        <div>
                            @if($title)<h3 class="text-base font-semibold text-dynamic">{{ $title }}</h3>@endif
                            @if($subtitle)<p class="text-xs mt-0.5 text-dynamic-muted">{{ $subtitle }}</p>@endif
                        </div>
                    </div>
                    @if($closeable && isset($closeAction))
                        <button wire:click="{{ $closeAction }}" class="btn-icon"><i class="ph ph-x text-base"></i></button>
                    @endif
                </div>
            @endif

            {{-- Content --}}
            <div class="p-5 {{ $mobileFullScreen ? 'max-sm:flex-1 max-sm:overflow-y-auto' : '' }}">
                {{ $slot }}
            </div>

            {{-- Footer --}}
            @if(isset($footer))
                <div class="flex items-center justify-end gap-3 px-5 py-4 shrink-0 border-t border-subtle bg-subtle">
                    {{ $footer }}
                </div>
            @endif
        </div>
    </div>
</div>
@elseif($name)
{{-- Alpine variable-based modal with name prop --}}
<div
    x-data="{ loading: {{ $loading ? 'true' : 'false' }} }"
    x-on:keydown.escape.window="@if(!$persistent && $closeable) {{ $name }} = false @endif"
    x-show="{{ $name }}"
    class="fixed inset-0 overflow-y-auto"
    style="display: none; z-index: var(--z-modal);"
>
    {{-- Backdrop --}}
    <div
        x-show="{{ $name }}"
        x-transition:enter="ease-out duration-200"
        x-transition:enter-start="opacity-0"
        x-transition:enter-end="opacity-100"
        x-transition:leave="ease-in duration-150"
        x-transition:leave-start="opacity-100"
        x-transition:leave-end="opacity-0"
        class="modal-backdrop fixed inset-0"
        @if($closeable && !$persistent) @click="{{ $name }} = false" @endif
    ></div>

    {{-- Modal Panel --}}
    <div class="modal-container flex min-h-full items-center justify-center p-4 {{ $mobileFullScreen ? 'max-sm:p-0' : '' }}">
        <div
            x-show="{{ $name }}"
            x-transition:enter="ease-out duration-200"
            x-transition:enter-start="opacity-0 scale-95"
            x-transition:enter-end="opacity-100 scale-100"
            x-transition:leave="ease-in duration-150"
            x-transition:leave-start="opacity-100 scale-100"
            x-transition:leave-end="opacity-0 scale-95"
            class="card-dynamic relative w-full transform overflow-hidden shadow-2xl {{ $maxWidthClasses }} {{ $mobileClasses }} {{ $mobileFullScreen ? 'max-sm:flex max-sm:flex-col max-sm:h-full' : '' }}"
            @click.stop
        >
            {{-- Loading Overlay --}}
            <div x-show="loading" x-transition class="absolute inset-0 flex items-center justify-center glass z-10">
                <div class="flex flex-col items-center gap-3">
                    <div class="loading-spinner loading-spinner-lg"></div>
                    <span class="text-sm text-dynamic-muted">@lang('Processing...')</span>
                </div>
            </div>

            {{-- Header --}}
            @if($title || $closeable)
                <div class="flex items-start justify-between px-5 py-4 shrink-0 border-b border-subtle">
                    <div class="flex items-center gap-3">
                        @if($icon)
                            <div class="flex h-10 w-10 items-center justify-center rounded-xl {{ $iconConfig['bg'] }}">
                                <i class="ph {{ $icon }} text-lg {{ $iconConfig['text'] }}"></i>
                            </div>
                        @endif
                        <div>
                            @if($title)<h3 class="text-base font-semibold text-dynamic">{{ $title }}</h3>@endif
                            @if($subtitle)<p class="text-xs mt-0.5 text-dynamic-muted">{{ $subtitle }}</p>@endif
                        </div>
                    </div>
                    @if($closeable)
                        <button @click="{{ $name }} = false" class="btn-icon"><i class="ph ph-x text-base"></i></button>
                    @endif
                </div>
            @endif

            {{-- Content --}}
            <div class="p-5 {{ $mobileFullScreen ? 'max-sm:flex-1 max-sm:overflow-y-auto' : '' }}">
                {{ $slot }}
            </div>

            {{-- Footer --}}
            @if(isset($footer))
                <div class="flex items-center justify-end gap-3 px-5 py-4 shrink-0 border-t border-subtle bg-subtle">
                    {{ $footer }}
                </div>
            @endif
        </div>
    </div>
</div>
@endif
