{{-- Sidebar Logo Component - Optimised for Professional Visibility --}}
@props([
    'maxHeight' => 'max-h-24',
    'maxWidth' => 'max-w-none',
    'containerClass' => '',
    'imageClass' => '',
])

@php
    $siteName = gs('site_name') ?? config('app.name', 'Salieno');
    
    $heightStyle = str_contains($maxHeight, 'max-h-') ? '' : "max-height: {$maxHeight}px;";
    $heightClass = str_contains($maxHeight, 'max-h-') ? $maxHeight : '';
    
    $baseImageClasses = "{$heightClass} h-auto w-auto {$maxWidth} object-contain object-left pointer-events-none select-none {$imageClass}";
    
    $lightLogo = siteLogo();
    $darkLogo = siteLogo('dark');
    
    // Check if we have real logos
    $hasRealLogo = !str_contains($lightLogo, 'default.png') || !str_contains($darkLogo, 'default.png');
@endphp

<div {{ $attributes->merge(['class' => "flex items-center logo-wrapper $containerClass"]) }} x-cloak>
    @if($hasRealLogo)
        <div class="relative flex items-center">
            {{-- Standard reactive logic for sidebars: uses :src to avoid duplicated elements --}}
            <img :src="$store.theme.on ? '{{ $lightLogo }}' : '{{ $darkLogo }}'" 
                 alt="{{ $siteName }}" 
                 class="{{ $baseImageClasses }}"
                 style="{{ $heightStyle }}">
        </div>
    @else
        {{-- Premium Textual Branding --}}
        <div class="flex items-center gap-3 group">
            <div class="relative flex items-center justify-center w-12 h-12 rounded-2xl bg-gradient-to-br from-primary-color to-primary-600 shadow-xl shadow-primary-color/20 active:scale-95 transition-all duration-300 group-hover:rotate-6">
                <i class="ph-duotone ph-lightning text-2xl text-white"></i>
            </div>
            <div class="flex flex-col">
                <span class="text-xl font-black tracking-tighter text-dynamic leading-none">{{ $siteName }}</span>
                <span class="text-[10px] font-bold uppercase tracking-[0.2em] text-dynamic-muted mt-1 opacity-60">Control Panel</span>
            </div>
        </div>
    @endif
</div>

