{{--
    Advanced Skeleton Loading Component
    Enterprise-grade skeleton system with contextual placeholders
    Supports: line, circle, card, stat-card, table-row, list-item, service-card,
              invoice-row, ticket-item, domain-card, transaction-row, profile,
              cart-item, announcement, message, dashboard, welcome, stats-grid
--}}
@props([
    'type' => 'line',
    'lines' => 3,
    'height' => null,
    'width' => null,
    'count' => 1,
    'delay' => 0, // Stagger delay in ms (0, 100, 200, etc.)
    'animated' => true,
])

@php
    $delayClass = $delay > 0 ? "skeleton-delay-{$delay}" : '';
    $baseClass = $animated ? 'skeleton-shimmer' : 'skeleton-static';
@endphp

@for($c = 0; $c < $count; $c++)
    @php $itemDelay = $delay + ($c * 75); @endphp

    {{-- Basic Line --}}
    @if($type === 'line')
        <div class="{{ $baseClass }} rounded-lg" style="height: {{ $height ?? '1rem' }}; width: {{ $width ?? '100%' }}; animation-delay: {{ $itemDelay }}ms;"></div>

    {{-- Circle (Avatar) --}}
    @elseif($type === 'circle')
        <div class="{{ $baseClass }} rounded-full" style="height: {{ $height ?? '3rem' }}; width: {{ $width ?? '3rem' }}; animation-delay: {{ $itemDelay }}ms;"></div>

    {{-- Basic Card --}}
    @elseif($type === 'card')
        <div class="skeleton-card rounded-2xl p-5" style="animation-delay: {{ $itemDelay }}ms;">
            <div class="space-y-4">
                @for($i = 0; $i < $lines; $i++)
                    <div class="{{ $baseClass }} rounded-lg" style="height: 1rem; width: {{ $i === 0 ? '60%' : ($i === $lines - 1 ? '40%' : '80%') }}; animation-delay: {{ $itemDelay + ($i * 50) }}ms;"></div>
                @endfor
            </div>
        </div>

    {{-- Stat Card (Dashboard Stats) --}}
    @elseif($type === 'stat-card')
        <div class="skeleton-card rounded-2xl p-5" style="animation-delay: {{ $itemDelay }}ms;">
            <div class="flex items-center justify-between mb-3">
                <div class="{{ $baseClass }} h-10 w-10 rounded-xl" style="animation-delay: {{ $itemDelay }}ms;"></div>
                <div class="{{ $baseClass }} h-5 w-16 rounded-full" style="animation-delay: {{ $itemDelay + 50 }}ms;"></div>
            </div>
            <div class="{{ $baseClass }} h-3 w-16 rounded-md mb-2" style="animation-delay: {{ $itemDelay + 100 }}ms;"></div>
            <div class="{{ $baseClass }} h-8 w-24 rounded-lg" style="animation-delay: {{ $itemDelay + 150 }}ms;"></div>
        </div>

    {{-- Balance Card (Primary colored stat) --}}
    @elseif($type === 'balance-card')
        <div class="skeleton-card-primary rounded-2xl p-5 col-span-2 lg:col-span-1" style="animation-delay: {{ $itemDelay }}ms;">
            <div class="flex items-center gap-2 mb-3">
                <div class="skeleton-shimmer-light h-5 w-5 rounded-md" style="animation-delay: {{ $itemDelay }}ms;"></div>
                <div class="skeleton-shimmer-light h-4 w-16 rounded-md" style="animation-delay: {{ $itemDelay + 50 }}ms;"></div>
            </div>
            <div class="skeleton-shimmer-light h-8 w-28 rounded-lg mb-3" style="animation-delay: {{ $itemDelay + 100 }}ms;"></div>
            <div class="flex items-center gap-1">
                <div class="skeleton-shimmer-light h-3 w-24 rounded-md" style="animation-delay: {{ $itemDelay + 150 }}ms;"></div>
            </div>
        </div>

    {{-- List Item --}}
    @elseif($type === 'list-item')
        <div class="skeleton-list-item flex items-center gap-4 px-5 py-4" style="animation-delay: {{ $itemDelay }}ms;">
            <div class="{{ $baseClass }} h-11 w-11 rounded-xl shrink-0" style="animation-delay: {{ $itemDelay }}ms;"></div>
            <div class="flex-1 space-y-2">
                <div class="{{ $baseClass }} h-4 rounded-lg" style="width: 75%; animation-delay: {{ $itemDelay + 50 }}ms;"></div>
                <div class="{{ $baseClass }} h-3 rounded-lg" style="width: 50%; animation-delay: {{ $itemDelay + 100 }}ms;"></div>
            </div>
            <div class="{{ $baseClass }} h-6 w-16 rounded-full" style="animation-delay: {{ $itemDelay + 150 }}ms;"></div>
        </div>

    {{-- Table Row --}}
    @elseif($type === 'table-row')
        <tr class="skeleton-table-row" style="animation-delay: {{ $itemDelay }}ms;">
            <td class="px-6 py-4"><div class="{{ $baseClass }} h-4 w-28 rounded-lg" style="animation-delay: {{ $itemDelay }}ms;"></div></td>
            <td class="px-6 py-4"><div class="{{ $baseClass }} h-4 w-20 rounded-lg" style="animation-delay: {{ $itemDelay + 30 }}ms;"></div></td>
            <td class="px-6 py-4"><div class="{{ $baseClass }} h-4 w-20 rounded-lg" style="animation-delay: {{ $itemDelay + 60 }}ms;"></div></td>
            <td class="px-6 py-4"><div class="{{ $baseClass }} h-4 w-16 rounded-lg" style="animation-delay: {{ $itemDelay + 90 }}ms;"></div></td>
            <td class="px-6 py-4"><div class="{{ $baseClass }} h-6 w-16 rounded-full" style="animation-delay: {{ $itemDelay + 120 }}ms;"></div></td>
            <td class="px-6 py-4 text-right"><div class="{{ $baseClass }} h-8 w-8 rounded-lg ml-auto" style="animation-delay: {{ $itemDelay + 150 }}ms;"></div></td>
        </tr>

    {{-- Service Card --}}
    @elseif($type === 'service-card')
        <div class="skeleton-card rounded-2xl p-5" style="animation-delay: {{ $itemDelay }}ms;">
            <div class="flex items-start justify-between mb-4">
                <div class="{{ $baseClass }} h-11 w-11 rounded-xl" style="animation-delay: {{ $itemDelay }}ms;"></div>
                <div class="{{ $baseClass }} h-6 w-16 rounded-lg" style="animation-delay: {{ $itemDelay + 50 }}ms;"></div>
            </div>
            <div class="{{ $baseClass }} h-5 w-3/4 rounded-lg mb-2" style="animation-delay: {{ $itemDelay + 100 }}ms;"></div>
            <div class="{{ $baseClass }} h-4 w-1/2 rounded-lg mb-4" style="animation-delay: {{ $itemDelay + 150 }}ms;"></div>
            <div class="pt-4" style="border-top: 1px solid var(--border);">
                <div class="flex items-center justify-between">
                    <div class="{{ $baseClass }} h-4 w-24 rounded-lg" style="animation-delay: {{ $itemDelay + 200 }}ms;"></div>
                    <div class="{{ $baseClass }} h-4 w-4 rounded" style="animation-delay: {{ $itemDelay + 250 }}ms;"></div>
                </div>
            </div>
        </div>

    {{-- Invoice Row (Mobile Card) --}}
    @elseif($type === 'invoice-card')
        <div class="skeleton-card rounded-2xl p-4" style="animation-delay: {{ $itemDelay }}ms;">
            <div class="flex items-start justify-between mb-3">
                <div class="flex items-center gap-3">
                    <div class="{{ $baseClass }} h-10 w-10 rounded-xl" style="animation-delay: {{ $itemDelay }}ms;"></div>
                    <div>
                        <div class="{{ $baseClass }} h-4 w-20 rounded-lg mb-1" style="animation-delay: {{ $itemDelay + 50 }}ms;"></div>
                        <div class="{{ $baseClass }} h-3 w-24 rounded-lg" style="animation-delay: {{ $itemDelay + 100 }}ms;"></div>
                    </div>
                </div>
                <div class="{{ $baseClass }} h-6 w-14 rounded-lg" style="animation-delay: {{ $itemDelay + 150 }}ms;"></div>
            </div>
            <div class="flex items-center justify-between pt-3" style="border-top: 1px solid var(--border);">
                <div>
                    <div class="{{ $baseClass }} h-3 w-14 rounded mb-1" style="animation-delay: {{ $itemDelay + 200 }}ms;"></div>
                    <div class="{{ $baseClass }} h-4 w-20 rounded" style="animation-delay: {{ $itemDelay + 250 }}ms;"></div>
                </div>
                <div class="text-right">
                    <div class="{{ $baseClass }} h-3 w-12 rounded mb-1" style="animation-delay: {{ $itemDelay + 200 }}ms;"></div>
                    <div class="{{ $baseClass }} h-5 w-16 rounded" style="animation-delay: {{ $itemDelay + 250 }}ms;"></div>
                </div>
            </div>
        </div>

    {{-- Ticket Item --}}
    @elseif($type === 'ticket-item')
        <div class="skeleton-card rounded-2xl p-5" style="animation-delay: {{ $itemDelay }}ms;">
            <div class="flex flex-col gap-4 sm:flex-row sm:items-center sm:justify-between">
                <div class="flex items-start gap-4">
                    <div class="{{ $baseClass }} h-10 w-10 rounded-xl shrink-0" style="animation-delay: {{ $itemDelay }}ms;"></div>
                    <div class="flex-1 min-w-0">
                        <div class="flex items-center gap-2 mb-2">
                            <div class="{{ $baseClass }} h-4 w-16 rounded-lg" style="animation-delay: {{ $itemDelay + 50 }}ms;"></div>
                            <div class="{{ $baseClass }} h-5 w-14 rounded-md" style="animation-delay: {{ $itemDelay + 100 }}ms;"></div>
                        </div>
                        <div class="{{ $baseClass }} h-5 w-64 max-w-full rounded-lg mb-2" style="animation-delay: {{ $itemDelay + 150 }}ms;"></div>
                        <div class="{{ $baseClass }} h-3 w-32 rounded-lg" style="animation-delay: {{ $itemDelay + 200 }}ms;"></div>
                    </div>
                </div>
                <div class="flex items-center gap-3">
                    <div class="{{ $baseClass }} h-6 w-20 rounded-lg" style="animation-delay: {{ $itemDelay + 250 }}ms;"></div>
                    <div class="{{ $baseClass }} h-4 w-4 rounded" style="animation-delay: {{ $itemDelay + 300 }}ms;"></div>
                </div>
            </div>
        </div>

    {{-- Domain Card --}}
    @elseif($type === 'domain-card')
        <div class="skeleton-card rounded-2xl p-5" style="animation-delay: {{ $itemDelay }}ms;">
            <div class="flex items-start justify-between mb-4">
                <div class="{{ $baseClass }} h-11 w-11 rounded-xl" style="animation-delay: {{ $itemDelay }}ms;"></div>
                <div class="{{ $baseClass }} h-6 w-16 rounded-lg" style="animation-delay: {{ $itemDelay + 50 }}ms;"></div>
            </div>
            <div class="{{ $baseClass }} h-5 w-40 rounded-lg mb-2" style="animation-delay: {{ $itemDelay + 100 }}ms;"></div>
            <div class="{{ $baseClass }} h-3 w-24 rounded-lg mb-4" style="animation-delay: {{ $itemDelay + 150 }}ms;"></div>
            <div class="pt-4 flex items-center justify-between" style="border-top: 1px solid var(--border);">
                <div class="{{ $baseClass }} h-4 w-28 rounded-lg" style="animation-delay: {{ $itemDelay + 200 }}ms;"></div>
                <div class="{{ $baseClass }} h-4 w-4 rounded" style="animation-delay: {{ $itemDelay + 250 }}ms;"></div>
            </div>
        </div>

    {{-- Transaction Row --}}
    @elseif($type === 'transaction-row')
        <div class="skeleton-list-item flex items-center gap-4 px-5 py-4" style="animation-delay: {{ $itemDelay }}ms;">
            <div class="{{ $baseClass }} h-10 w-10 rounded-xl shrink-0" style="animation-delay: {{ $itemDelay }}ms;"></div>
            <div class="flex-1 min-w-0">
                <div class="{{ $baseClass }} h-4 w-48 max-w-full rounded-lg mb-1" style="animation-delay: {{ $itemDelay + 50 }}ms;"></div>
                <div class="{{ $baseClass }} h-3 w-24 rounded-lg" style="animation-delay: {{ $itemDelay + 100 }}ms;"></div>
            </div>
            <div class="text-right">
                <div class="{{ $baseClass }} h-5 w-20 rounded-lg mb-1" style="animation-delay: {{ $itemDelay + 150 }}ms;"></div>
                <div class="{{ $baseClass }} h-3 w-14 rounded-lg" style="animation-delay: {{ $itemDelay + 200 }}ms;"></div>
            </div>
        </div>

    {{-- Cart Item --}}
    @elseif($type === 'cart-item')
        <div class="skeleton-card rounded-xl p-4" style="animation-delay: {{ $itemDelay }}ms;">
            <div class="flex items-center justify-between">
                <div class="flex items-center gap-3">
                    <div class="{{ $baseClass }} h-10 w-10 rounded-lg" style="animation-delay: {{ $itemDelay }}ms;"></div>
                    <div>
                        <div class="{{ $baseClass }} h-4 w-32 rounded-lg mb-1" style="animation-delay: {{ $itemDelay + 50 }}ms;"></div>
                        <div class="{{ $baseClass }} h-3 w-20 rounded-lg" style="animation-delay: {{ $itemDelay + 100 }}ms;"></div>
                    </div>
                </div>
                <div class="{{ $baseClass }} h-5 w-16 rounded-lg" style="animation-delay: {{ $itemDelay + 150 }}ms;"></div>
            </div>
        </div>

    {{-- Announcement Card --}}
    @elseif($type === 'announcement')
        <div class="skeleton-card rounded-2xl p-5" style="animation-delay: {{ $itemDelay }}ms;">
            <div class="flex items-start gap-4">
                <div class="{{ $baseClass }} h-10 w-10 rounded-xl shrink-0" style="animation-delay: {{ $itemDelay }}ms;"></div>
                <div class="flex-1">
                    <div class="{{ $baseClass }} h-5 w-3/4 rounded-lg mb-2" style="animation-delay: {{ $itemDelay + 50 }}ms;"></div>
                    <div class="{{ $baseClass }} h-4 w-full rounded-lg mb-1" style="animation-delay: {{ $itemDelay + 100 }}ms;"></div>
                    <div class="{{ $baseClass }} h-4 w-2/3 rounded-lg mb-3" style="animation-delay: {{ $itemDelay + 150 }}ms;"></div>
                    <div class="{{ $baseClass }} h-3 w-24 rounded-lg" style="animation-delay: {{ $itemDelay + 200 }}ms;"></div>
                </div>
            </div>
        </div>

    {{-- Message Bubble --}}
    @elseif($type === 'message')
        <div class="flex gap-3 mb-4" style="animation-delay: {{ $itemDelay }}ms;">
            <div class="{{ $baseClass }} h-10 w-10 rounded-full shrink-0" style="animation-delay: {{ $itemDelay }}ms;"></div>
            <div class="flex-1 max-w-xl">
                <div class="flex items-center gap-2 mb-2">
                    <div class="{{ $baseClass }} h-4 w-24 rounded-lg" style="animation-delay: {{ $itemDelay + 50 }}ms;"></div>
                    <div class="{{ $baseClass }} h-3 w-16 rounded-lg" style="animation-delay: {{ $itemDelay + 100 }}ms;"></div>
                </div>
                <div class="skeleton-card rounded-2xl rounded-tl-sm p-4">
                    <div class="{{ $baseClass }} h-4 w-full rounded-lg mb-2" style="animation-delay: {{ $itemDelay + 150 }}ms;"></div>
                    <div class="{{ $baseClass }} h-4 w-3/4 rounded-lg" style="animation-delay: {{ $itemDelay + 200 }}ms;"></div>
                </div>
            </div>
        </div>

    {{-- Profile Section --}}
    @elseif($type === 'profile')
        <div class="skeleton-card rounded-2xl p-6" style="animation-delay: {{ $itemDelay }}ms;">
            <div class="flex flex-col items-center mb-6">
                <div class="{{ $baseClass }} h-28 w-28 rounded-full mb-4" style="animation-delay: {{ $itemDelay }}ms;"></div>
                <div class="{{ $baseClass }} h-5 w-32 rounded-lg mb-2" style="animation-delay: {{ $itemDelay + 100 }}ms;"></div>
                <div class="{{ $baseClass }} h-4 w-40 rounded-lg" style="animation-delay: {{ $itemDelay + 150 }}ms;"></div>
            </div>
            <div class="space-y-4">
                @for($i = 0; $i < 3; $i++)
                    <div>
                        <div class="{{ $baseClass }} h-3 w-20 rounded mb-2" style="animation-delay: {{ $itemDelay + 200 + ($i * 50) }}ms;"></div>
                        <div class="{{ $baseClass }} h-10 w-full rounded-xl" style="animation-delay: {{ $itemDelay + 250 + ($i * 50) }}ms;"></div>
                    </div>
                @endfor
            </div>
        </div>

    {{-- Welcome Section --}}
    @elseif($type === 'welcome')
        <div class="flex flex-col gap-6 lg:flex-row lg:items-center lg:justify-between" style="animation-delay: {{ $itemDelay }}ms;">
            <div>
                <div class="{{ $baseClass }} h-8 w-64 rounded-lg mb-3" style="animation-delay: {{ $itemDelay }}ms;"></div>
                <div class="{{ $baseClass }} h-4 w-80 max-w-full rounded-lg" style="animation-delay: {{ $itemDelay + 100 }}ms;"></div>
            </div>
            <div class="flex gap-3">
                <div class="{{ $baseClass }} h-11 w-32 rounded-xl" style="animation-delay: {{ $itemDelay + 200 }}ms;"></div>
                <div class="{{ $baseClass }} h-11 w-28 rounded-xl" style="animation-delay: {{ $itemDelay + 250 }}ms;"></div>
            </div>
        </div>

    {{-- Stats Grid (4 cards) --}}
    @elseif($type === 'stats-grid')
        <div class="grid grid-cols-2 gap-4 lg:grid-cols-4" style="animation-delay: {{ $itemDelay }}ms;">
            <x-client.skeleton type="balance-card" :delay="$itemDelay" />
            <x-client.skeleton type="stat-card" :delay="$itemDelay + 100" />
            <x-client.skeleton type="stat-card" :delay="$itemDelay + 200" />
            <x-client.skeleton type="stat-card" :delay="$itemDelay + 300" />
        </div>

    {{-- Dashboard Full Page Skeleton --}}
    @elseif($type === 'dashboard')
        <div class="space-y-6 lg:space-y-8">
            <x-client.skeleton type="welcome" />
            <x-client.skeleton type="stats-grid" :delay="200" />
            <div class="grid gap-6 lg:grid-cols-2">
                <x-client.skeleton type="card" :lines="5" :delay="400" />
                <x-client.skeleton type="card" :lines="5" :delay="500" />
            </div>
        </div>

    {{-- Filter Bar --}}
    @elseif($type === 'filter-bar')
        <div class="skeleton-card rounded-2xl p-4" style="animation-delay: {{ $itemDelay }}ms;">
            <div class="flex flex-col gap-4 lg:flex-row lg:items-center">
                <div class="{{ $baseClass }} h-11 w-full max-w-xs rounded-xl" style="animation-delay: {{ $itemDelay }}ms;"></div>
                <div class="flex flex-wrap gap-2">
                    @for($i = 0; $i < 4; $i++)
                        <div class="{{ $baseClass }} h-10 w-20 rounded-xl" style="animation-delay: {{ $itemDelay + 50 + ($i * 30) }}ms;"></div>
                    @endfor
                </div>
            </div>
        </div>

    {{-- Page Header --}}
    @elseif($type === 'page-header')
        <div class="flex flex-col gap-4 lg:flex-row lg:items-center lg:justify-between" style="animation-delay: {{ $itemDelay }}ms;">
            <div class="flex items-center gap-4">
                <div class="{{ $baseClass }} h-12 w-12 rounded-xl" style="animation-delay: {{ $itemDelay }}ms;"></div>
                <div>
                    <div class="{{ $baseClass }} h-6 w-40 rounded-lg mb-2" style="animation-delay: {{ $itemDelay + 50 }}ms;"></div>
                    <div class="{{ $baseClass }} h-4 w-56 rounded-lg" style="animation-delay: {{ $itemDelay + 100 }}ms;"></div>
                </div>
            </div>
            <div class="{{ $baseClass }} h-11 w-32 rounded-xl" style="animation-delay: {{ $itemDelay + 150 }}ms;"></div>
        </div>

    {{-- Default fallback --}}
    @else
        <div class="{{ $baseClass }} rounded-lg" style="height: {{ $height ?? '1rem' }}; width: {{ $width ?? '100%' }}; animation-delay: {{ $itemDelay }}ms;"></div>
    @endif
@endfor

