@props([
    'title',
    'value',
    'icon',
    'color' => 'primary',
    'trend' => null,
    'trendValue' => null,
    'href' => null,
    'subtitle' => null,
])

@php
    $colorConfig = match($color) {
        'primary' => ['bg' => 'bg-primary-light', 'text' => 'text-primary-color'],
        'success' => ['bg' => 'bg-success-light', 'text' => 'text-success-color'],
        'warning' => ['bg' => 'bg-warning-light', 'text' => 'text-warning-color'],
        'danger' => ['bg' => 'bg-danger-light', 'text' => 'text-danger-color'],
        'info' => ['bg' => 'bg-info-light', 'text' => 'text-info-color'],
        'secondary' => ['bg' => 'bg-subtle', 'text' => 'text-dynamic-muted'],
        default => ['bg' => 'bg-primary-light', 'text' => 'text-primary-color'],
    };
@endphp

@if($href)<a href="{{ $href }}" class="group block">@endif
    <div {{ $attributes->merge(['class' => 'card-dynamic card-hover relative overflow-hidden p-5']) }}>
        {{-- Soft Background Glow --}}
        <div class="absolute -right-6 -top-6 h-24 w-24 rounded-full opacity-30 blur-2xl {{ $colorConfig['bg'] }}"></div>

        <div class="relative">
            {{-- Header with Icon --}}
            <div class="flex items-center justify-between mb-3">
                <div class="flex h-11 w-11 items-center justify-center rounded-xl {{ $colorConfig['bg'] }}">
                    <i class="ph-duotone {{ $icon }} text-xl {{ $colorConfig['text'] }}"></i>
                </div>
                @if($href)
                    <i class="ph-bold ph-arrow-right text-sm opacity-0 transition-all group-hover:opacity-100 group-hover:translate-x-1 {{ $colorConfig['text'] }}"></i>
                @endif
            </div>

            {{-- Content --}}
            <p class="text-sm font-medium text-dynamic-muted">{{ $title }}</p>
            <p class="mt-1 text-2xl font-bold tracking-tight text-dynamic">{{ $value }}</p>

            @if($subtitle)
                <p class="mt-0.5 text-xs text-dynamic-muted">{{ $subtitle }}</p>
            @endif

            @if($trend && $trendValue)
                <div class="mt-2 flex items-center gap-1.5">
                    <span class="badge {{ $trend === 'up' ? 'badge-success' : 'badge-danger' }} text-xs">
                        <i class="ph-bold {{ $trend === 'up' ? 'ph-trend-up' : 'ph-trend-down' }} text-2xs"></i>
                        {{ $trendValue }}
                    </span>
                    <span class="text-xs text-dynamic-muted">@lang('vs last month')</span>
                </div>
            @endif
        </div>
    </div>
@if($href)</a>@endif

