{{-- Toast Notifications Container - Modern Design --}}
<div
    x-data="{ toasts: [], add(toast) { const id = Date.now(); this.toasts.push({ id, ...toast }); setTimeout(() => this.remove(id), toast.duration || 5000); }, remove(id) { this.toasts = this.toasts.filter(t => t.id !== id); } }"
    @toast.window="add($event.detail)"
    class="pointer-events-none fixed bottom-0 right-0 z-50 flex flex-col gap-3 p-4 sm:p-6"
>
    <template x-for="toast in toasts" :key="toast.id">
        <div
            x-show="true"
            x-transition:enter="transition ease-out duration-200"
            x-transition:enter-start="opacity-0 translate-y-2 scale-95"
            x-transition:enter-end="opacity-100 translate-y-0 scale-100"
            x-transition:leave="transition ease-in duration-150"
            x-transition:leave-start="opacity-100"
            x-transition:leave-end="opacity-0 translate-y-2"
            class="card-dynamic pointer-events-auto flex w-full max-w-sm items-start gap-3 p-4 shadow-xl"
        >
            {{-- Icon --}}
            <div
                class="flex h-10 w-10 shrink-0 items-center justify-center rounded-xl text-white"
                :class="{
                    'bg-success': toast.type === 'success',
                    'bg-danger': toast.type === 'error',
                    'bg-warning': toast.type === 'warning',
                    'bg-info': toast.type === 'info' || !toast.type
                }"
            >
                <i class="ph-duotone text-lg" :class="{ 'ph-check-circle': toast.type === 'success', 'ph-x-circle': toast.type === 'error', 'ph-warning': toast.type === 'warning', 'ph-info': toast.type === 'info' || !toast.type }"></i>
            </div>

            {{-- Content --}}
            <div class="flex-1 min-w-0 pt-0.5">
                <p class="text-sm font-semibold text-dynamic" x-text="toast.title || (toast.type === 'success' ? 'Success!' : toast.type === 'error' ? 'Error!' : toast.type === 'warning' ? 'Warning!' : 'Info')"></p>
                <p class="mt-0.5 text-sm text-dynamic-secondary" x-text="toast.message"></p>
            </div>

            {{-- Close Button --}}
            <button @click="remove(toast.id)" class="btn-icon shrink-0">
                <i class="ph-bold ph-x text-sm"></i>
            </button>
        </div>
    </template>
</div>

