{{-- Universal Logo Component - Works across all templates --}}
@props([
    'maxHeight' => 'max-h-28',
    'maxWidth' => 'max-w-[320px]',
    'containerClass' => '',
    'imageClass' => '',
])

@php
    $logoFile = gs('logo');
    $darkLogoFile = gs('dark_logo');
    $logoPath = getFilePath('logo');
    
    // Check if logo files exist in database and filesystem
    $hasLogo = false;
    $hasDarkLogo = false;
    
    if ($logoFile && file_exists(public_path($logoPath . '/' . $logoFile))) {
        $hasLogo = true;
    } elseif (file_exists(public_path($logoPath . '/logo.png'))) {
        $hasLogo = true;
    }
    
    if ($darkLogoFile && file_exists(public_path($logoPath . '/' . $darkLogoFile))) {
        $hasDarkLogo = true;
    } elseif (file_exists(public_path($logoPath . '/logo_dark.png'))) {
        $hasDarkLogo = true;
    }
    
    // Get branding settings for fallback
    $branding = @getContent('branding.content', true);
    $showIcon = @$branding->data_values->show_icon ?? 'yes';
    
    // Merge classes
    $containerClasses = "flex items-center h-28 logo-wrapper {$containerClass}";
    $baseImageClasses = "{$maxHeight} h-auto w-auto {$maxWidth} object-contain object-left pointer-events-none select-none {$imageClass}";
@endphp

@if($hasLogo || $hasDarkLogo)
    {{-- Logo container with strict height constraints to prevent navbar size changes --}}
    <div {{ $attributes->merge(['class' => $containerClasses]) }} x-cloak>
        @if($hasDarkLogo)
            {{-- Dark logo for light backgrounds --}}
            <img src="{{ siteLogo('dark') }}" 
                 alt="{{ gs('site_name') }}" 
                 class="{{ $baseImageClasses }} dark:hidden"
                 loading="eager"
                 {{-- Add x-show for instant reactivity during SPA navigation --}}
                 x-show="!$store.theme.on">
        @endif
        
        @if($hasLogo)
            {{-- Light/white logo for dark backgrounds --}}
            <img src="{{ siteLogo() }}" 
                 alt="{{ gs('site_name') }}" 
                 class="{{ $baseImageClasses }} hidden dark:block"
                 loading="eager"
                 x-show="$store.theme.on">
        @elseif($hasDarkLogo)
            {{-- Fallback: invert dark logo for dark mode if no light logo exists --}}
            <img src="{{ siteLogo('dark') }}" 
                 alt="{{ gs('site_name') }}" 
                 class="{{ $baseImageClasses }} hidden dark:block brightness-0 invert"
                 loading="eager"
                 x-show="$store.theme.on">
        @endif
    </div>
@else
    {{-- Fallback: Site name with icon when no logo is uploaded --}}
    <div {{ $attributes->merge(['class' => 'flex items-center gap-2 font-display font-bold text-xl tracking-tight text-slate-900 dark:text-white']) }}>
        @if($showIcon !== 'no')
            <div class="relative flex items-center justify-center w-8 h-8 rounded-lg bg-gradient-to-br from-primary-500 to-primary-600 shadow-lg shadow-primary-500/20">
                <svg class="w-5 h-5 text-white" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2.5" d="M13 10V3L4 14h7v7l9-11h-7z" />
                </svg>
            </div>
        @endif
        <span>{{ gs('site_name') ?? config('app.name', 'Salieno') }}</span>
    </div>
@endif
