{{-- Feature Icon Component --}}
@php
    // Single consistent coloring pattern using the primary theme color
    $bgClass = 'bg-primary-500/10 text-primary-600 dark:text-primary-400';
    $hoverClass = 'group-hover:bg-primary-600';
@endphp

<div class="relative w-24 h-24 mx-auto mb-8 transition-all duration-500 group-hover:scale-110 flex items-center justify-center">
    {{-- Soft Glow/Aura --}}
    <div class="absolute inset-0 bg-primary-500/30 rounded-3xl blur-2xl opacity-0 group-hover:opacity-100 transition-opacity duration-500"></div>
    
    {{-- Main Icon Circle --}}
    <div class="relative w-20 h-20 {{ $bgClass }} {{ $hoverClass }} rounded-[2rem] flex items-center justify-center transition-all duration-300 group-hover:text-white shadow-sm ring-1 ring-white/5 dark:ring-white/10 group-hover:shadow-lg">
        <i class="ph {{ $icon }} text-4xl leading-none"></i>
    </div>
</div>


