@props(['title' => 'Admin'])

<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}" class="h-full">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title>{{ $title ?? 'Admin' }} | {{ gs('site_name') ?? 'Salieno' }}</title>

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.bunny.net">
    <link href="https://fonts.bunny.net/css?family=inter:100,200,300,400,500,600,700,800,900|jetbrains-mono:400,500,600,700" rel="stylesheet" />

    <!-- Icons - Phosphor Icons -->
    <script src="https://unpkg.com/@phosphor-icons/web@2.0.3" nonce="{{ csp_nonce() }}"></script>

    <!-- Scripts -->
    @vite(['resources/css/app.css', 'resources/js/app.js'])
    @livewireStyles

    <style>
        [x-cloak] { display: none !important; }

        /* Hide Livewire's default thin progress bar */
        [x-ref="bar"] { display: none !important; }

        /* Navigation overlay loader */
        .nav-overlay {
            position: fixed;
            inset: 0;
            z-index: 9999;
            display: flex;
            align-items: center;
            justify-content: center;
            background: rgba(10, 10, 15, 0.6);
            backdrop-filter: blur(4px);
            opacity: 0;
            pointer-events: none;
            transition: opacity 0.15s ease;
        }
        .nav-overlay.active {
            opacity: 1;
            pointer-events: all;
        }
        .nav-spinner {
            width: 40px;
            height: 40px;
            border: 3px solid rgba(255, 255, 255, 0.1);
            border-top-color: #818cf8;
            border-radius: 50%;
            animation: nav-spin 0.6s linear infinite;
        }
        @keyframes nav-spin {
            to { transform: rotate(360deg); }
        }
    </style>
</head>
<body
    x-data="{
        sidebarOpen: localStorage.getItem('admin_sidebar_open') !== 'false',
        sidebarMobileOpen: false,
        toggleSidebar() {
            this.sidebarOpen = !this.sidebarOpen;
            localStorage.setItem('admin_sidebar_open', this.sidebarOpen);
        },
        toggleMobileSidebar() {
            this.sidebarMobileOpen = !this.sidebarMobileOpen;
        },
        closeMobileSidebar() {
            this.sidebarMobileOpen = false;
        }
    }"
    class="h-full bg-[#0a0a0f] font-sans antialiased"
>
    @if(config('app.demo_mode'))
    <div class="bg-amber-500 text-black text-center text-sm font-semibold py-2 px-4 z-[9999] relative">
        <i class="ph-bold ph-warning-circle mr-1"></i>
        @lang('Demo Mode — All changes are disabled. Login credentials and data will reset periodically.')
    </div>
    @endif

    <!-- Navigation Overlay Loader -->
    <div id="nav-overlay" class="nav-overlay">
        <div class="nav-spinner"></div>
    </div>

    <div class="flex h-full">
        <!-- Mobile Sidebar Backdrop -->
        <div
            x-show="sidebarMobileOpen"
            x-transition:enter="transition-opacity ease-linear duration-300"
            x-transition:enter-start="opacity-0"
            x-transition:enter-end="opacity-100"
            x-transition:leave="transition-opacity ease-linear duration-300"
            x-transition:leave-start="opacity-100"
            x-transition:leave-end="opacity-0"
            @click="closeMobileSidebar()"
            class="fixed inset-0 z-40 bg-black/60 backdrop-blur-sm lg:hidden"
        ></div>

        <!-- Sidebar -->
        <x-admin.sidebar />

        <!-- Main Content Area -->
        <div
            class="flex flex-1 flex-col transition-all duration-300"
            :class="sidebarOpen ? 'lg:pl-[272px]' : 'lg:pl-[80px]'"
        >
            <!-- Header -->
            <x-admin.header :title="$title ?? 'Dashboard'" />

            <!-- Page Content -->
            <main class="flex-1 overflow-y-auto p-6 lg:p-8">
                <div class="mx-auto max-w-[1600px]">
                    <!-- Breadcrumbs -->
                    @if(isset($breadcrumbs))
                        <nav class="mb-6 flex items-center gap-2 text-sm" aria-label="Breadcrumb">
                            <a href="{{ route('admin.dashboard') }}" class="text-slate-500 transition-colors hover:text-indigo-400">
                                <i class="ph-duotone ph-house text-lg"></i>
                            </a>
                            {{ $breadcrumbs }}
                        </nav>
                    @endif

                    <!-- Page Header -->
                    @if(isset($header))
                        <div class="mb-8">
                            {{ $header }}
                        </div>
                    @endif

                    <!-- Main Slot -->
                    {{ $slot }}
                </div>
            </main>

            <!-- Footer -->
            <footer class="border-t border-white/5 px-6 py-4 lg:px-8">
                <div class="mx-auto flex max-w-[1600px] flex-wrap items-center justify-between gap-4 text-sm text-slate-500">
                    <p>&copy; {{ date('Y') }} {{ gs('site_name') ?? 'Salieno' }}. @lang('All rights reserved').</p>
                    <div class="flex items-center gap-6">
                        <p class="flex items-center gap-2">
                            <span class="relative flex h-2 w-2">
                                <span class="absolute inline-flex h-full w-full animate-ping rounded-full bg-emerald-400 opacity-75"></span>
                                <span class="relative inline-flex h-2 w-2 rounded-full bg-emerald-500"></span>
                            </span>
                            @lang('All Systems Operational')
                        </p>
                        <span class="text-slate-600">v1.0.0</span>
                    </div>
                </div>
            </footer>
        </div>
    </div>

    <!-- Toast Notifications -->
    <x-admin.toast />

    @livewireScripts

    <!-- Navigation Overlay Controller -->
    <script nonce="{{ csp_nonce() }}">
        (function() {
            const overlay = document.getElementById('nav-overlay');
            document.addEventListener('livewire:navigate', () => overlay.classList.add('active'));
            document.addEventListener('livewire:navigated', () => overlay.classList.remove('active'));
        })();
    </script>

    <!-- Toast Helper -->
    <script nonce="{{ csp_nonce() }}">
        window.toast = function(options) {
            window.dispatchEvent(new CustomEvent('toast', { detail: options }));
        };

        // Demo mode: intercept blocked Livewire requests and show toast
        @if(config('app.demo_mode'))
        document.addEventListener('livewire:init', () => {
            Livewire.hook('request', ({ fail }) => {
                fail(({ status, content, preventDefault }) => {
                    if (status === 403) {
                        preventDefault();
                        try {
                            const data = JSON.parse(content);
                            window.toast({ type: 'warning', message: data.message || 'This action is disabled in demo mode.' });
                        } catch (e) {
                            window.toast({ type: 'warning', message: 'This action is disabled in demo mode.' });
                        }
                    }
                });
            });
        });
        @endif

        // Keyboard shortcut for search (Cmd+K / Ctrl+K)
        document.addEventListener('keydown', function(e) {
            if ((e.metaKey || e.ctrlKey) && e.key === 'k') {
                e.preventDefault();
                document.querySelector('input[type="search"]')?.focus();
            }
        });

        // Trigger toasts from session
        function checkFlashMessages() {
            @if(session('success'))
                window.toast({ type: 'success', message: "{{ session('success') }}" });
            @endif
            @if(session('error'))
                window.toast({ type: 'error', message: "{{ session('error') }}" });
            @endif
            @if(session('info'))
                window.toast({ type: 'info', message: "{{ session('info') }}" });
            @endif
            @if(session('warning'))
                window.toast({ type: 'warning', message: "{{ session('warning') }}" });
            @endif
        }

        document.addEventListener('DOMContentLoaded', checkFlashMessages);
        document.addEventListener('livewire:navigated', checkFlashMessages);
    </script>

    <!-- Page-specific scripts -->
    @stack('scripts')
</body>
</html>

