@props(['feature', 'size' => 'md', 'showTooltip' => true])
 
@php
    use App\Helpers\FeatureHelper;
    
    $typeClasses = FeatureHelper::getTypeClasses($feature->type);
    $typeIcon = FeatureHelper::getTypeIcon($feature->type, $feature->icon);
    $displayValue = FeatureHelper::getCombinedValue($feature);
    $badgeHtml = FeatureHelper::getBadgeHtml($feature->badge_text, $feature->badge_color);
    
    // Inherit tooltip from CategoryFeature if possible
    $tooltip = $feature->tooltip_text ?: ($feature->categoryFeature?->tooltip_text ?: $feature->description);
    $hasTooltip = $showTooltip && $tooltip;
    
    $sizeClasses = match($size) {
        'sm' => 'text-[10px]',
        'lg' => 'text-base',
        default => 'text-xs',
    };
    
    $iconSize = match($size) {
        'sm' => 'w-5! h-5!',
        'lg' => 'w-8! h-8!',
        default => 'w-7! h-7!',
    };
@endphp
 
<div class="flex items-center gap-3 group/feature {{ $sizeClasses }} relative" 
     @if($hasTooltip) 
         x-data="{ showTooltip: false }"
         @mouseenter="showTooltip = true" 
         @mouseleave="showTooltip = false"
     @endif>
    
    {{-- Icon --}}
    <div class="flex-shrink-0 {{ $iconSize }} rounded-xl flex items-center justify-center border border-slate-200 dark:border-white/10 bg-white dark:bg-slate-800/50 {{ $typeClasses }} transition-all duration-500 group-hover/feature:shadow-lg group-hover/feature:shadow-primary-500/10 group-hover/feature:scale-110">
        <div class="scale-90">{!! $typeIcon !!}</div>
    </div>
    
    {{-- Content --}}
    <div class="flex-1 min-w-0">
        <div class="flex items-center gap-2 flex-wrap">
            <span class="text-slate-800 dark:text-slate-200 group-hover/feature:text-primary-600 dark:group-hover/feature:text-white transition-colors font-bold uppercase tracking-tight">
                {{ __($displayValue) }}
            </span>
            
            {{-- Type badge for unlimited --}}
            @if($feature->type === 'unlimited')
                <span class="inline-flex items-center px-1.5 py-0.5 rounded-full text-[8px] font-bold uppercase tracking-widest bg-primary-500/10 text-primary-600 dark:text-primary-400 border border-primary-500/20">
                    {{ __('Unlimited') }}
                </span>
            @endif
            
            {{-- Custom badge if set --}}
            @if($badgeHtml)
                <div class="scale-90 origin-left">
                    {!! $badgeHtml !!}
                </div>
            @endif
            
            {{-- Tooltip indicator --}}
            @if($hasTooltip)
                <i class="ph ph-info text-slate-400 group-hover/feature:text-primary-500 transition-colors cursor-help"></i>
            @endif
        </div>
    </div>
    
    {{-- Tooltip --}}
    @if($hasTooltip)
        <div x-show="showTooltip" 
             x-transition:enter="transition ease-out duration-200"
             x-transition:enter-start="opacity-0 translate-y-2 scale-95"
             x-transition:enter-end="opacity-100 translate-y-0 scale-100"
             x-transition:leave="transition ease-in duration-150"
             x-transition:leave-start="opacity-100 translate-y-0 scale-100"
             x-transition:leave-end="opacity-0 translate-y-2 scale-95"
             class="absolute bottom-full left-0 mb-3 z-50 px-4 py-3 text-[10px] font-medium text-white bg-slate-900/90 border border-white/10 rounded-2xl shadow-2xl backdrop-blur-xl max-w-xs ring-4 ring-black/5"
             style="display: none;">
            <div class="relative z-10">
                {{ $tooltip }}
            </div>
            <div class="absolute bottom-0 left-4 w-2 h-2 bg-slate-900 border-r border-b border-white/10 rotate-45 -mb-1"></div>
        </div>
    @endif
</div>
