@props([
    'data' => [],
    'selectedCycle' => 'monthly',
    'highlightDifferences' => false,
    'showPricing' => true
])

<div class="overflow-x-auto rounded-xl border" style="border-color: var(--border); background: var(--card-bg);">
    <table class="w-full text-left border-collapse">
        <thead>
            <tr style="border-bottom: 1px solid var(--border);">
                <th class="p-4 text-sm font-bold" style="color: var(--text-muted);">@lang('Features')</th>
                @foreach($data['products'] ?? [] as $product)
                    <th class="p-4 text-sm font-bold uppercase tracking-tight" style="color: var(--text-primary);">
                        {{ __($product['name']) }}
                    </th>
                @endforeach
            </tr>
        </thead>
        <tbody class="divide-y" style="border-color: var(--border);">
            <tr class="hover:opacity-80 transition-opacity">
                <td class="p-4 text-sm font-medium" style="color: var(--text-secondary);">@lang('Price')</td>
                @foreach($data['products'] ?? [] as $product)
                    <td class="p-4 text-sm font-bold" style="color: var(--primary);">
                        {{ gs('cur_sym') }}{{ $product['pricing']['cycles'][$selectedCycle]['price_raw'] ?? $product['pricing']['monthly'] ?? '0.00' }}
                    </td>
                @endforeach
            </tr>
            {{-- Generic feature rows could be added here if defined in data --}}
        </tbody>
    </table>
</div>
