@props([
    'cycles' => [],
    'selected' => 'monthly',
    'style' => 'pills',
    'eventName' => 'cycle-changed'
])

<div {{ $attributes->merge(['class' => 'inline-flex p-1 border rounded-lg', 'style' => 'background: var(--card-bg); border-color: var(--border);']) }}>
    @foreach($cycles as $cycle => $cData)
        @php
            $label = is_array($cData) ? ($cData['label'] ?? $cycle) : $cData;
        @endphp
        <button 
            type="button"
            @click="$dispatch('{{ $eventName }}', { cycle: '{{ $cycle }}' })"
            class="px-4 py-2 rounded-md text-sm font-medium transition-all"
            :class="$wire.{{ $attributes->wire('model')->value() ?? 'selectedCycle' }} == '{{ $cycle }}' ? 'text-white' : ''"
            :style="$wire.{{ $attributes->wire('model')->value() ?? 'selectedCycle' }} == '{{ $cycle }}' ? 'background: var(--primary);' : 'color: var(--text-secondary);'"
        >
            {{ __($label) }}
        </button>
    @endforeach
</div>
