@props([
    'type' => 'button',
    'variant' => 'primary',
    'size' => 'md',
    'rounded' => 'md',
])

@php
    $baseStyles = "inline-flex items-center justify-center font-medium transition-all duration-200 border";
    $sizeClasses = [
        'sm' => 'px-3 py-1.5 text-xs',
        'md' => 'px-4 py-2 text-sm',
        'lg' => 'px-6 py-3 text-base',
    ];
    $variantStyles = [
        'primary' => 'background: var(--primary); color: white; border-color: transparent;',
        'secondary' => 'background: var(--secondary); color: white; border-color: transparent;',
        'outline' => 'background: transparent; border-color: var(--border); color: var(--text-primary);',
        'ghost' => 'background: transparent; border-color: transparent; color: var(--text-secondary);',
    ];

    $classes = $baseStyles . " " . ($sizeClasses[$size] ?? $sizeClasses['md']);
    $style = $variantStyles[$variant] ?? $variantStyles['primary'];
@endphp

@if($attributes->has('href'))
    <a {{ $attributes->merge(['class' => $classes, 'style' => $style . " border-radius: var(--radius-{$rounded}, 8px);"]) }}>
        {{ $slot }}
    </a>
@else
    <button type="{{ $type }}" {{ $attributes->merge(['class' => $classes, 'style' => $style . " border-radius: var(--radius-{$rounded}, 8px);"]) }}>
        {{ $slot }}
    </button>
@endif
