<!DOCTYPE html>
<html lang="en" class="dark">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Domain Mismatch - Salieno Core</title>
    <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-gray-950 min-h-screen flex items-center justify-center p-4">
    <div class="max-w-md w-full">
        <div class="bg-gray-900 border border-gray-800 rounded-2xl p-8 text-center">
            {{-- Icon --}}
            <div class="w-16 h-16 mx-auto mb-6 bg-orange-500/20 rounded-full flex items-center justify-center">
                <svg class="w-8 h-8 text-orange-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 12a9 9 0 01-9 9m9-9a9 9 0 00-9-9m9 9H3m9 9a9 9 0 01-9-9m9 9c1.657 0 3-4.03 3-9s-1.343-9-3-9m0 18c-1.657 0-3-4.03-3-9s1.343-9 3-9m-9 9a9 9 0 019-9"/>
                </svg>
            </div>

            {{-- Title --}}
            <h1 class="text-2xl font-bold text-white mb-2">Domain Mismatch</h1>

            {{-- Message --}}
            <p class="text-gray-400 mb-6">{{ $message ?? 'This installation is not authorized to run on this domain.' }}</p>

            <div class="bg-gray-800/50 rounded-lg p-4 mb-6 text-left">
                <p class="text-sm text-gray-400 mb-2">Current Domain:</p>
                <p class="text-white font-mono text-sm">{{ request()->getHost() }}</p>
            </div>

            {{-- Actions --}}
            <div class="space-y-3">
                <a href="{{ route('admin.license.status') }}" class="block w-full py-3 px-4 bg-primary-600 hover:bg-primary-700 text-white font-medium rounded-lg transition-colors">
                    View License Status
                </a>
                <a href="https://salieno.com/client/licenses" target="_blank" class="block w-full py-3 px-4 bg-gray-800 hover:bg-gray-700 text-gray-300 font-medium rounded-lg transition-colors">
                    Update Domain on Salieno.com
                </a>
            </div>

            {{-- Help --}}
            <p class="mt-6 text-xs text-gray-500">
                Need help? Contact <a href="https://salieno.com/support" class="text-primary-400 hover:underline" target="_blank">Salieno Support</a>
            </p>
        </div>
    </div>
</body>
</html>

