<!DOCTYPE html>
<html lang="en" class="dark">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Security Alert - Salieno Core</title>
    <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-gray-950 min-h-screen flex items-center justify-center p-4">
    <div class="max-w-md w-full">
        <div class="bg-gray-900 border border-red-800 rounded-2xl p-8 text-center">
            {{-- Icon --}}
            <div class="w-16 h-16 mx-auto mb-6 bg-red-500/20 rounded-full flex items-center justify-center">
                <svg class="w-8 h-8 text-red-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 15v2m-6 4h12a2 2 0 002-2v-6a2 2 0 00-2-2H6a2 2 0 00-2 2v6a2 2 0 002 2zm10-10V7a4 4 0 00-8 0v4h8z"/>
                </svg>
            </div>

            {{-- Title --}}
            <h1 class="text-2xl font-bold text-white mb-2">Security Alert</h1>

            {{-- Message --}}
            <p class="text-gray-400 mb-6">{{ $message ?? 'File integrity check failed. Core files may have been modified.' }}</p>

            <div class="bg-red-500/10 border border-red-500/30 rounded-lg p-4 mb-6">
                <p class="text-sm text-red-400">
                    <strong>Warning:</strong> Unauthorized modifications to core files have been detected. 
                    This could indicate a security breach or corrupted installation.
                </p>
            </div>

            {{-- Actions --}}
            <div class="space-y-3">
                <a href="https://salieno.com/client/downloads" target="_blank" class="block w-full py-3 px-4 bg-primary-600 hover:bg-primary-700 text-white font-medium rounded-lg transition-colors">
                    Download Fresh Copy
                </a>
                <a href="https://salieno.com/support" target="_blank" class="block w-full py-3 px-4 bg-gray-800 hover:bg-gray-700 text-gray-300 font-medium rounded-lg transition-colors">
                    Contact Support
                </a>
            </div>

            {{-- Help --}}
            <p class="mt-6 text-xs text-gray-500">
                If you believe this is an error, please contact <a href="https://salieno.com/support" class="text-primary-400 hover:underline" target="_blank">Salieno Support</a>
            </p>
        </div>
    </div>
</body>
</html>

