<!DOCTYPE html>
<html lang="en" class="dark">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>License Error - Salieno Core</title>
    <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-gray-950 min-h-screen flex items-center justify-center p-4">
    <div class="max-w-md w-full">
        <div class="bg-gray-900 border border-gray-800 rounded-2xl p-8 text-center">
            {{-- Icon --}}
            <div class="w-16 h-16 mx-auto mb-6 bg-red-500/20 rounded-full flex items-center justify-center">
                <svg class="w-8 h-8 text-red-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-3L13.732 4c-.77-1.333-2.694-1.333-3.464 0L3.34 16c-.77 1.333.192 3 1.732 3z"/>
                </svg>
            </div>

            {{-- Title --}}
            <h1 class="text-2xl font-bold text-white mb-2">License Error</h1>

            {{-- Message --}}
            <p class="text-gray-400 mb-6">{{ $message ?? 'Your Salieno Core license is invalid or has expired.' }}</p>

            @if($grace_period ?? false)
                <div class="bg-amber-500/10 border border-amber-500/30 rounded-lg p-4 mb-6">
                    <p class="text-sm text-amber-400">
                        <strong>Grace Period Active:</strong> Your system is running in grace period mode. 
                        Please verify your license within the next few days to avoid service interruption.
                    </p>
                </div>
            @endif

            {{-- Actions --}}
            <div class="space-y-3">
                <a href="{{ route('admin.license.activate') }}" class="block w-full py-3 px-4 bg-primary-600 hover:bg-primary-700 text-white font-medium rounded-lg transition-colors">
                    Activate License
                </a>
                <a href="https://salieno.com/client/licenses" target="_blank" class="block w-full py-3 px-4 bg-gray-800 hover:bg-gray-700 text-gray-300 font-medium rounded-lg transition-colors">
                    Manage License on Salieno.com
                </a>
            </div>

            {{-- Help --}}
            <p class="mt-6 text-xs text-gray-500">
                Need help? Contact <a href="https://salieno.com/support" class="text-primary-400 hover:underline" target="_blank">Salieno Support</a>
            </p>
        </div>
    </div>
</body>
</html>

