<!DOCTYPE html>
<html lang="en" class="dark">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Module Unavailable - Salieno Core</title>
    <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-gray-950 min-h-screen flex items-center justify-center p-4">
    <div class="max-w-md w-full">
        <div class="bg-gray-900 border border-gray-800 rounded-2xl p-8 text-center">
            {{-- Icon --}}
            <div class="w-16 h-16 mx-auto mb-6 bg-blue-500/20 rounded-full flex items-center justify-center">
                <svg class="w-8 h-8 text-blue-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 11H5m14 0a2 2 0 012 2v6a2 2 0 01-2 2H5a2 2 0 01-2-2v-6a2 2 0 012-2m14 0V9a2 2 0 00-2-2M5 11V9a2 2 0 012-2m0 0V5a2 2 0 012-2h6a2 2 0 012 2v2M7 7h10"/>
                </svg>
            </div>

            {{-- Title --}}
            <h1 class="text-2xl font-bold text-white mb-2">Module Unavailable</h1>

            {{-- Message --}}
            <p class="text-gray-400 mb-6">
                The <span class="text-primary-400 font-semibold">{{ ucfirst(str_replace('_', ' ', $module)) }}</span> module is not included in your current plan.
            </p>

            {{-- Actions --}}
            <div class="space-y-3">
                <a href="https://salieno.com/pricing" target="_blank" class="block w-full py-3 px-4 bg-primary-600 hover:bg-primary-700 text-white font-medium rounded-lg transition-colors">
                    View Available Plans
                </a>
                <a href="{{ url()->previous() }}" class="block w-full py-3 px-4 bg-gray-800 hover:bg-gray-700 text-gray-300 font-medium rounded-lg transition-colors">
                    Go Back
                </a>
            </div>

            {{-- Help --}}
            <p class="mt-6 text-xs text-gray-500">
                Need this module? <a href="https://salieno.com/contact" class="text-primary-400 hover:underline" target="_blank">Contact sales</a> for custom plans.
            </p>
        </div>
    </div>
</body>
</html>

