<!DOCTYPE html>
<html lang="en" class="dark">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Upgrade Required - Salieno Core</title>
    <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-gray-950 min-h-screen flex items-center justify-center p-4">
    <div class="max-w-md w-full">
        <div class="bg-gray-900 border border-gray-800 rounded-2xl p-8 text-center">
            {{-- Icon --}}
            <div class="w-16 h-16 mx-auto mb-6 bg-amber-500/20 rounded-full flex items-center justify-center">
                <svg class="w-8 h-8 text-amber-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 10V3L4 14h7v7l9-11h-7z"/>
                </svg>
            </div>

            {{-- Title --}}
            <h1 class="text-2xl font-bold text-white mb-2">Upgrade Required</h1>

            {{-- Message --}}
            <p class="text-gray-400 mb-6">
                This feature requires the <span class="text-primary-400 font-semibold">{{ ucfirst($required_tier) }}</span> plan or higher.
            </p>

            {{-- Current vs Required --}}
            <div class="bg-gray-800/50 rounded-lg p-4 mb-6">
                <div class="flex items-center justify-between text-sm">
                    <div>
                        <p class="text-gray-500">Current Plan</p>
                        <p class="text-white font-medium">{{ ucfirst($current_tier ?? 'Starter') }}</p>
                    </div>
                    <svg class="w-5 h-5 text-gray-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 7l5 5m0 0l-5 5m5-5H6"/>
                    </svg>
                    <div>
                        <p class="text-gray-500">Required Plan</p>
                        <p class="text-primary-400 font-medium">{{ ucfirst($required_tier) }}</p>
                    </div>
                </div>
            </div>

            {{-- Actions --}}
            <div class="space-y-3">
                <a href="https://salieno.com/pricing" target="_blank" class="block w-full py-3 px-4 bg-primary-600 hover:bg-primary-700 text-white font-medium rounded-lg transition-colors">
                    Upgrade Now
                </a>
                <a href="{{ url()->previous() }}" class="block w-full py-3 px-4 bg-gray-800 hover:bg-gray-700 text-gray-300 font-medium rounded-lg transition-colors">
                    Go Back
                </a>
            </div>

            {{-- Features --}}
            <div class="mt-6 pt-6 border-t border-gray-800 text-left">
                <p class="text-xs text-gray-500 mb-3">{{ ucfirst($required_tier) }} plan includes:</p>
                <ul class="space-y-2 text-sm text-gray-400">
                    @if($required_tier === 'professional')
                        <li class="flex items-center gap-2">
                            <svg class="w-4 h-4 text-green-400" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"/></svg>
                            Multi-server management
                        </li>
                        <li class="flex items-center gap-2">
                            <svg class="w-4 h-4 text-green-400" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"/></svg>
                            Advanced automation
                        </li>
                        <li class="flex items-center gap-2">
                            <svg class="w-4 h-4 text-green-400" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"/></svg>
                            API access
                        </li>
                    @elseif($required_tier === 'enterprise')
                        <li class="flex items-center gap-2">
                            <svg class="w-4 h-4 text-green-400" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"/></svg>
                            White-label branding
                        </li>
                        <li class="flex items-center gap-2">
                            <svg class="w-4 h-4 text-green-400" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"/></svg>
                            Priority support
                        </li>
                        <li class="flex items-center gap-2">
                            <svg class="w-4 h-4 text-green-400" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"/></svg>
                            Custom modules
                        </li>
                    @endif
                </ul>
            </div>
        </div>
    </div>
</body>
</html>

