<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}" class="h-full">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="{{ csrf_token() }}">

    <title>{{ $title ?? 'Admin' }} | {{ gs('site_name') ?? 'Salieno' }}</title>
    <link rel="icon" type="image/png" href="{{ siteFavicon() }}">

    <!-- Fonts (async: non-blocking) -->
    <link rel="preconnect" href="https://fonts.bunny.net">
    <link href="https://fonts.bunny.net/css?family=inter:400,500,600,700&display=swap" rel="stylesheet" media="print" onload="this.media='all'" />
    <noscript><link href="https://fonts.bunny.net/css?family=inter:400,500,600,700&display=swap" rel="stylesheet" /></noscript>

    <!-- Icons - Phosphor (defer: non-blocking) -->
    <script src="https://unpkg.com/@phosphor-icons/web@2.0.3" defer nonce="{{ csp_nonce() }}"></script>

    <!-- Scripts -->
    @vite(['resources/css/app.css', 'resources/js/app.js'])
    @livewireStyles

    <style>
        [x-cloak] { display: none !important; }

        /* Override autofill background for dark inputs */
        input:-webkit-autofill,
        input:-webkit-autofill:hover,
        input:-webkit-autofill:focus {
            -webkit-box-shadow: 0 0 0 1000px rgba(255, 255, 255, 0.05) inset !important;
            -webkit-text-fill-color: #fff !important;
            transition: background-color 5000s ease-in-out 0s;
        }
    </style>
</head>
<body class="h-full bg-[#0a0a0f] antialiased font-[Inter]">
    {{-- Subtle animated background --}}
    <div class="fixed inset-0 overflow-hidden pointer-events-none">
        <div class="absolute -top-1/2 -left-1/2 w-full h-full bg-gradient-to-br from-indigo-500/[0.03] to-transparent rounded-full blur-3xl"></div>
        <div class="absolute -bottom-1/2 -right-1/2 w-full h-full bg-gradient-to-tl from-purple-500/[0.03] to-transparent rounded-full blur-3xl"></div>
    </div>

    @if(config('app.demo_mode'))
    <div class="bg-amber-500 text-black text-center text-sm font-semibold py-2 px-4 z-[9999] relative">
        <i class="ph-bold ph-warning-circle mr-1"></i>
        @lang('Demo Mode — Login credentials and data will reset periodically.')
    </div>
    @endif

    <div class="relative min-h-full flex flex-col justify-center py-12 px-4 sm:px-6 lg:px-8">
        {{-- Logo --}}
        <div class="sm:mx-auto sm:w-full sm:max-w-md mb-8">
            <div class="flex justify-center">
                <a href="{{ url('/') }}">
                    <img src="{{ siteLogo() }}" alt="{{ gs('site_name') ?? 'Salieno' }}" class="max-h-20 w-auto" />
                </a>
            </div>
            <p class="mt-4 text-center text-sm text-slate-500">
                @lang('Admin Panel')
            </p>
        </div>

        {{-- Content card --}}
        <div class="sm:mx-auto sm:w-full sm:max-w-[440px]">
            <div class="rounded-2xl border border-white/[0.06] bg-white/[0.03] p-8 shadow-2xl shadow-black/30 backdrop-blur-sm">
                {{ $slot }}
            </div>
        </div>

        {{-- Footer --}}
        <div class="mt-8 text-center">
            <p class="text-xs text-slate-600">
                &copy; {{ date('Y') }} {{ gs('site_name') ?? 'Salieno' }}. @lang('All rights reserved.')
            </p>
        </div>
    </div>

    {{-- Toast Notifications --}}
    <x-admin.toast />

    @livewireScripts

    <script nonce="{{ csp_nonce() }}">
        window.toast = function(options) {
            window.dispatchEvent(new CustomEvent('toast', { detail: options }));
        };

        @if(config('app.demo_mode'))
        document.addEventListener('livewire:init', () => {
            Livewire.hook('request', ({ fail }) => {
                fail(({ status, content, preventDefault }) => {
                    if (status === 403) {
                        preventDefault();
                        try {
                            const data = JSON.parse(content);
                            window.toast({ type: 'warning', message: data.message || 'This action is disabled in demo mode.' });
                        } catch (e) {
                            window.toast({ type: 'warning', message: 'This action is disabled in demo mode.' });
                        }
                    }
                });
            });
        });
        @endif
    </script>
</body>
</html>
