@php
    $cs = clientAreaSettings();
    $layoutStyle = $cs['layout_style'] ?? 'sidebar';
    $sidebarWidth = $cs['sidebar_width'] ?? '280';
    $sidebarPosition = $cs['sidebar_position'] ?? 'left';
@endphp
<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}" 
      class="h-full">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title>@hasSection('title')@yield('title')@else{{ $title ?? 'Dashboard' }}@endif | {{ gs('site_name') ?? 'Salieno' }}</title>
    <link rel="icon" type="image/png" href="{{ siteFavicon() }}">
    <link rel="shortcut icon" type="image/png" href="{{ siteFavicon() }}">

    {{-- Theme Controller — Shared with frontend template (Single Source of Truth) --}}
    @include('partials.theme-controller')

    @php
        // CLI-02: Color computation cached in service (was 80 lines of inline PHP)
        $theme = app(\App\Services\ClientAreaThemeService::class)->getTheme();
        $v = $theme['vars'];
    @endphp
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="{{ $theme['font_url'] }}" rel="stylesheet" media="print" onload="this.media='all'" />
    <noscript><link href="{{ $theme['font_url'] }}" rel="stylesheet" /></noscript>

    <style>
        [x-cloak] { display: none !important; }

        h1, h2, h3, h4, h5, h6, .heading-1, .heading-2, .heading-3, .heading-4 {
            font-family: var(--heading-font);
        }

        /* Global font reset - Ensuring all text uses the theme font while preserving icons */
        *:not(i, [class^="ph-"], [class*=" ph-"], [class^="fa-"], [class*=" fa-"]) {
            font-family: var(--font-family);
        }

        :root {
            /* ===== DYNAMIC DESIGN SYSTEM (from ClientAreaThemeService — cached) ===== */
            --sidebar-width: {{ $v['sidebar_width'] }}px;
            --border-radius: {{ $v['border_radius'] }}px;
            --primary: {{ $v['primary'] }};
            --primary-hover: {{ $v['primary_hover'] }};
            --secondary: {{ $v['secondary'] }};
            --accent: {{ $v['accent'] }};
            --success: {{ $v['success'] }};
            --warning: {{ $v['warning'] }};
            --danger: {{ $v['danger'] }};
            --info: {{ $v['info'] }};
            --bg: {{ $v['bg'] }};
            --card-bg: {{ $v['card_bg'] }};
            --card-border: {{ $v['card_border'] }};
            --borderColor: {{ $v['border_color'] }};
            --sidebar-bg: {{ $v['sidebar_bg'] }};
            --sidebar-text: {{ $v['sidebar_text'] }};
            --sidebar-active-bg: {{ $v['sidebar_active_bg'] }};
            --sidebar-active-text: {{ $v['sidebar_active_text'] }};
            --sidebar-hover-bg: {{ $v['sidebar_hover_bg'] }};
            --header-bg: {{ $v['header_bg'] }};
            --header-text: {{ $v['header_text'] }};
            --header-border: {{ $v['header_border'] }};
            --text-primary: {{ $v['text_primary'] }};
            --text-secondary: {{ $v['text_secondary'] }};
            --text-muted: {{ $v['text_muted'] }};
            --linkColor: {{ $v['link_color'] }};
            --linkHover: {{ $v['link_hover'] }};
            --btn-radius: {{ $v['btn_radius'] }};
            --card-shadow: {{ $v['card_shadow'] }};

            /* Font - Standardized for Tailwind v4 Sync */
            --font-family: '{{ $v['font_family'] }}', -apple-system, BlinkMacSystemFont, 'Segoe UI', sans-serif;
            --font-sans: '{{ $v['font_family'] }}', -apple-system, BlinkMacSystemFont, 'Segoe UI', sans-serif;
            --heading-font: '{{ $v['heading_font'] }}', -apple-system, BlinkMacSystemFont, 'Segoe UI', sans-serif;

            /* Hover & Behavioral Configuration */
            --btn-hover-transform: {{ $v['btn_hover_transform'] }};
            --btn-hover-shadow: none;
            --btn-hover-filter: {{ $v['btn_hover_filter'] }};
            --card-hover-transform: {{ $v['card_hover_transform'] }};
            --card-hover-shadow: {{ $v['card_hover_shadow'] }};
            --card-hover-border-color: {{ $v['card_hover_border'] }};

            /* Glassmorphism - FORCED DISABLE */
            --glass-blur: none;
            --glass-bg: var(--card-bg);
            --glass-border: 1px solid var(--card-border);
            --glass-shadow: none;
            --glass-bg-dark: var(--card-bg);
            --glass-shadow-dark: none;

            /* Gradients - FORCED DISABLE */
            --btn-primary-border: 1px solid transparent;
            --btn-primary-shadow: none;
            --btn-primary-hover-shadow: none;
            --bg-primary-val: var(--primary);

            /* Derived colors */
            --primary-50: color-mix(in srgb, var(--primary) 5%, white);
            --primary-100: color-mix(in srgb, var(--primary) 10%, white);
            --primary-200: color-mix(in srgb, var(--primary) 18%, white);
            --primary-light: {{ $v['primary_light'] }};
            --border: {{ $v['border_color'] }};
            --border-subtle: color-mix(in srgb, {{ $v['border_color'] }}, transparent 40%);
            --gradient-primary: var(--primary);
            --gradient-surface: var(--bg);

            /* Status color tints (light mode) */
            --success-light: color-mix(in srgb, var(--success) 10%, white);
            --success-dark: color-mix(in srgb, var(--success), black 15%);
            --warning-light: color-mix(in srgb, var(--warning) 10%, white);
            --warning-dark: color-mix(in srgb, var(--warning), black 15%);
            --danger-light: color-mix(in srgb, var(--danger) 10%, white);
            --danger-dark: color-mix(in srgb, var(--danger), black 15%);
            --info-light: color-mix(in srgb, var(--info) 10%, white);
            --info-dark: color-mix(in srgb, var(--info), black 15%);

            /* Shadows — defined via opacity token so dark mode can override centrally */
            --shadow-base-opacity: 0.05;
            --shadow-xs: 0 1px 2px rgba(0, 0, 0, calc(var(--shadow-base-opacity) * 0.8));
            --shadow-sm: 0 1px 3px rgba(0, 0, 0, var(--shadow-base-opacity)), 0 1px 2px rgba(0, 0, 0, calc(var(--shadow-base-opacity) * 0.8));
            --shadow-md: 0 4px 6px rgba(0, 0, 0, var(--shadow-base-opacity)), 0 2px 4px rgba(0, 0, 0, calc(var(--shadow-base-opacity) * 0.8));
            --shadow-lg: 0 10px 15px rgba(0, 0, 0, calc(var(--shadow-base-opacity) * 1.2)), 0 4px 6px rgba(0, 0, 0, calc(var(--shadow-base-opacity) * 0.8));
            --shadow-xl: 0 20px 25px rgba(0, 0, 0, calc(var(--shadow-base-opacity) * 1.6)), 0 10px 10px rgba(0, 0, 0, calc(var(--shadow-base-opacity) * 0.8));
            --shadow-glow: 0 0 20px color-mix(in srgb, var(--primary) 15%, transparent);

            /* Interactive states */
            --bg-subtle: #F1F5F9;
            --card-bg-hover: #F8FAFC;
            --text-disabled: #CBD5E1;
            --link: var(--primary);
            --link-hover: var(--primary-hover);

            /* Aliases used by pages (guest-checkout, mobile-nav, dashboard) */
            --bg-color: var(--bg);
            --bg-gradient-from: var(--bg-subtle);
            --radius-card: var(--border-radius, 12px);
        }

        /* ===== DARK MODE OVERRIDES ===== */
        html.dark {
            --bg: {{ $v['dark_bg'] }};
            --bg-subtle: rgba(255, 255, 255, 0.03);
            --sidebar-bg: {{ $v['dark_sidebar_bg'] }};
            --card-bg: {{ $v['dark_card_bg'] }};
            --card-bg-hover: {{ $v['dark_card_bg_hover'] }};
            --header-bg: {{ $v['dark_bg'] }};
            --border: rgba(255, 255, 255, 0.08);
            --border-subtle: rgba(255, 255, 255, 0.04);
            --borderColor: rgba(255, 255, 255, 0.12);
            --card-border: rgba(255, 255, 255, 0.08);
            --header-border: rgba(255, 255, 255, 0.08);
            --text-primary: #f4f4f5;
            --text-secondary: #a1a1aa;
            --text-muted: #71717a;
            --text-disabled: #52525b;
            --link: {{ $v['primary'] }};
            --link-hover: {{ $v['dark_link_hover'] }};
            --sidebar-hover-bg: {{ $v['dark_sidebar_hover'] }};
            --primary-light: color-mix(in srgb, var(--primary) 12%, transparent);
            --primary-50: color-mix(in srgb, var(--primary) 8%, transparent);
            --primary-100: color-mix(in srgb, var(--primary) 14%, transparent);
            --primary-200: color-mix(in srgb, var(--primary) 22%, transparent);
            --success-light: color-mix(in srgb, var(--success) 12%, transparent);
            --warning-light: color-mix(in srgb, var(--warning) 12%, transparent);
            --danger-light: color-mix(in srgb, var(--danger) 12%, transparent);
            --info-light: color-mix(in srgb, var(--info) 12%, transparent);
            /* Dark mode: increase shadow opacity centrally — all --shadow-* auto-adjust */
            --shadow-base-opacity: 0.25;
            --shadow-glow: 0 0 20px color-mix(in srgb, var(--primary) 20%, transparent);
            --gradient-surface: {{ $v['dark_bg'] }};
        }

        /* Custom CSS from Admin Settings — sanitized (CLI-03) */
        {{ $theme['custom_css'] }}
    </style>

    @vite(['resources/css/app.css', 'resources/css/client-area.css', 'resources/js/app.js', 'resources/js/client-area.js'])
    @livewireStyles

    <!-- Icons - Phosphor Icons (Synced with Frontend) -->
    <script src="https://unpkg.com/@phosphor-icons/web@2.1.1" 
        integrity="sha384-cPFV+/abYd3INVFHPmSKpBmcnH+Q+bTZW7dv/EiuShUNPkHyFmRF8PsL7Ibfvunk" 
        crossorigin="anonymous" defer nonce="{{ csp_nonce() }}"></script>
    {{-- CLI-01: Stray </style> tag removed --}}

    @stack('styles')
</head>
<body x-data="{ sidebarOpen: false, touchStartX: 0, touchStartY: 0 }" class="h-full antialiased" style="background-color: var(--bg);">
    @if(config('app.demo_mode'))
    <div class="bg-amber-500 text-black text-center text-sm font-semibold py-2 px-4 z-[9999] relative">
        <i class="ph-bold ph-warning-circle mr-1"></i>
        @lang('Demo Mode — All changes are disabled. This is a preview only.')
    </div>
    @endif

    {{-- CLI-08: Only instantiate component when admin is actually impersonating --}}
    @if(session('impersonating'))
        <x-client.impersonation-banner />
    @endif

    @if($cs['enable_animations'] ?? true)
    <!-- Background Elements — static gradients, GPU-optimized (CLI-04) -->
    <div class="fixed inset-0 z-0 overflow-hidden pointer-events-none opacity-30 dark:opacity-60 motion-safe:opacity-40 motion-safe:dark:opacity-80"
         style="will-change: transform; contain: strict;">
        <div class="absolute inset-0 bg-grid-client"></div>
        {{-- Static radial gradients instead of animated blur blobs.
             Much cheaper than blur-[120px] + animate-blob on mobile GPUs.
             Uses will-change:transform and contain:strict to isolate compositing. --}}
        <div class="absolute top-[-5%] left-[-10%] w-[30%] md:w-[40%] h-[30%] md:h-[40%] rounded-full
                    bg-[radial-gradient(circle,_var(--primary)_0%,_transparent_70%)]
                    opacity-10 dark:opacity-20"></div>
        <div class="absolute bottom-[-5%] right-[-10%] w-[30%] md:w-[40%] h-[30%] md:h-[40%] rounded-full
                    bg-[radial-gradient(circle,_#f43f5e_0%,_transparent_70%)]
                    opacity-10 dark:opacity-20"></div>
    </div>
    @endif

    @if($layoutStyle === 'topnav')
        {{-- TOP NAVIGATION LAYOUT --}}
        <div class="min-h-screen flex flex-col" style="background-color: var(--bg);">
            @include('partials.client.topnav')

            <main class="flex-1 px-4 py-8 lg:px-8 pb-8">
                <div class="mx-auto max-w-6xl">
                    @hasSection('content')
                        @yield('content')
                    @else
                        {{ $slot ?? '' }}
                    @endif
                </div>
            </main>

            @include('partials.client.footer')
            @include('partials.client.mobile-bottom-nav')
        </div>
    @else
        {{-- SIDEBAR LAYOUT --}}
        <div class="flex min-h-screen {{ $sidebarPosition === 'right' ? 'flex-row-reverse' : '' }}" style="background-color: var(--bg);">
            @include('partials.client.sidebar')

            <div class="flex flex-1 flex-col {{ $sidebarPosition === 'right' ? 'lg:mr-[var(--sidebar-width)]' : 'lg:ml-[var(--sidebar-width)]' }}">
                @include('partials.client.header')

                <main class="flex-1 px-4 py-6 lg:px-8 lg:py-8 pb-8">
                    <div class="mx-auto max-w-6xl">
                        @hasSection('content')
                            @yield('content')
                        @else
                            {{ $slot ?? '' }}
                        @endif
                    </div>
                </main>

                @include('partials.client.footer')
                @include('partials.client.mobile-bottom-nav')
            </div>
        </div>

    @endif

    <x-client.toast x-persist="client-toast" />
    @livewireScripts

    <!-- Global Page Loader (must be AFTER livewireScripts) -->
    @include('partials.livewire-loader')

    <!-- Demo mode Livewire intercept -->
    @if(config('app.demo_mode'))
    <script nonce="{{ csp_nonce() }}">
        document.addEventListener('livewire:init', () => {
            Livewire.hook('request', ({ fail }) => {
                fail(({ status, content, preventDefault }) => {
                    if (status === 403) {
                        preventDefault();
                        try {
                            const data = JSON.parse(content);
                            window.toast({ type: 'warning', message: data.message || 'This action is disabled in demo mode.' });
                        } catch (e) {
                            window.toast({ type: 'warning', message: 'This action is disabled in demo mode.' });
                        }
                    }
                });
            });
        });
    </script>
    @endif


    @include('partials.client.push-notification')

    @if(gs('ticket_livechat_enabled'))
        <livewire:frontend.live-chat.chat-widget/>
    @endif

    @stack('scripts')

    {{-- Global Search Component --}}
    <livewire:client.global-search />
</body>
</html>
