<!DOCTYPE html>
<html lang="en" class="h-full dark">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Salieno | Advanced Auto-Installer</title>
    <link rel="icon" type="image/x-icon" href="{{ asset('favicon.ico') }}">
    
    {{-- Fonts --}}
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700;800;900&family=Manrope:wght@800&display=swap" rel="stylesheet">
    
    {{-- Phosphor Icons (local assets) --}}
    <link rel="stylesheet" href="{{ asset('assets/phosphor/bold.css') }}">
    <link rel="stylesheet" href="{{ asset('assets/phosphor/fill.css') }}">
    <link rel="stylesheet" href="{{ asset('assets/phosphor/regular.css') }}">

    {{-- Salieno Template CSS & JS via Vite (full design system: buttons, components, colors) --}}
    @vite([
        'resources/views/templates/salieno/assets/css/salieno.css',
        'resources/views/templates/salieno/assets/js/salieno.js'
    ])

    {{-- Theme Colors from theme.json — Required for salieno.css color palette generation --}}
    @php
        $themeFile = resource_path('views/templates/salieno/theme.json');
        $themeColors = file_exists($themeFile)
            ? (json_decode(file_get_contents($themeFile), true)['colors'] ?? [])
            : [];

        $primary = $themeColors['primary'] ?? '#CC2628';
        $neutralDark = $themeColors['neutral_dark'] ?? '#0A0A0A';
        $neutralMid = $themeColors['neutral_mid'] ?? '#18181B';
        $neutralBorder = $themeColors['neutral_border'] ?? '#27272A';
        $neutralMuted = $themeColors['neutral_muted'] ?? '#A1A1AA';
        $headingLight = $themeColors['heading_light'] ?? '#1f1b4d';
        $surfaceOffwhite = $themeColors['surface_offwhite'] ?? '#fcfcfd';
        $svgDark = $themeColors['svg_dark'] ?? '#0f172a';
        $svgMid = $themeColors['svg_mid'] ?? '#1e293b';
        $svgLight = $themeColors['svg_light'] ?? '#334155';
        $svgMuted = $themeColors['svg_muted'] ?? '#94a3b8';
        $svgSubtle = $themeColors['svg_subtle'] ?? '#cbd5e1';
        $svgSurface = $themeColors['svg_surface'] ?? '#f1f5f9';

        // Convert hex to RGB for color-mix utilities
        $hex = str_replace('#', '', $primary);
        $r = hexdec(substr($hex, 0, 2));
        $g = hexdec(substr($hex, 2, 2));
        $b = hexdec(substr($hex, 4, 2));
        $primaryRgb = "$r, $g, $b";
    @endphp

    <style>
        [x-cloak] { display: none !important; }
        html { color-scheme: dark; }

        :root {
            --primary: {{ $primary }};
            --primary-rgb: {{ $primaryRgb }};
            --primary-tint: color-mix(in srgb, var(--primary), white 20%);
            --primary-shade: color-mix(in srgb, var(--primary), black 20%);
            --primary-glow: color-mix(in srgb, var(--primary), transparent 85%);

            --neutral-dark: {{ $neutralDark }};
            --neutral-mid: {{ $neutralMid }};
            --neutral-border: {{ $neutralBorder }};
            --neutral-muted: {{ $neutralMuted }};

            --heading-light: {{ $headingLight }};
            --surface-offwhite: {{ $surfaceOffwhite }};
            --svg-dark: {{ $svgDark }};
            --svg-mid: {{ $svgMid }};
            --svg-light: {{ $svgLight }};
            --svg-muted: {{ $svgMuted }};
            --svg-subtle: {{ $svgSubtle }};
            --svg-surface: {{ $svgSurface }};

            --font-family: 'Inter', -apple-system, BlinkMacSystemFont, 'Segoe UI', sans-serif;
            --font-sans: 'Inter', -apple-system, BlinkMacSystemFont, 'Segoe UI', sans-serif;
            --heading-font: 'Manrope', -apple-system, BlinkMacSystemFont, 'Segoe UI', sans-serif;

            --theme-bg-dark: var(--neutral-dark);
            --theme-text-dark: #ffffff;
            --theme-text-muted: var(--neutral-muted);
        }

        body {
            background-color: var(--neutral-dark) !important;
            color: #e2e8f0 !important;
        }

        @keyframes pulse-glow {
            0%, 100% { opacity: 0.6; transform: scale(1); }
            50% { opacity: 1; transform: scale(1.1); }
        }
        .animate-pulse-glow { animation: pulse-glow 10s ease-in-out infinite; }
    </style>
    <script nonce="{{ csp_nonce() }}">document.documentElement.classList.add('dark');</script>
    @livewireStyles
</head>
<body class="h-full bg-slate-950 font-sans overflow-x-hidden">
    
    {{-- High-End Salieno Technical Background --}}
    <div class="fixed inset-0 z-0 pointer-events-none overflow-hidden bg-slate-950">
        {{-- Technical Grid Pattern (Synchronized with Hero) --}}
        <div class="absolute inset-0 bg-[linear-gradient(to_right,#80808012_1px,transparent_1px),linear-gradient(to_bottom,#80808012_1px,transparent_1px)] bg-[size:4rem_4rem] [mask-image:radial-gradient(ellipse_60%_50%_at_50%_0%,#000_70%,transparent_100%)]"></div>
        
        {{-- The Sun / Light Source (Orange-tinted Glow) --}}
        <div class="absolute -top-[15%] -right-[5%] w-[800px] h-[800px] opacity-60">
            <div class="absolute inset-0 bg-orange-500/20 rounded-full blur-[100px] animate-pulse-glow"></div>
        </div>

        {{-- Smooth Transition Fade --}}
        <div class="absolute inset-0 bg-gradient-to-b from-transparent via-slate-950/50 to-slate-950"></div>
    </div>

    <div class="relative z-10 min-h-full flex flex-col p-4 sm:p-6 lg:p-8">
        {{-- Header --}}
        <header class="max-w-4xl mx-auto w-full mb-12 flex flex-col items-center">
            <div class="inline-flex items-center space-x-3 bg-primary-500/10 border border-primary-500/30 rounded-full px-4 py-2 mb-6 backdrop-blur-md">
                <span class="relative inline-flex rounded-full h-2 w-2 bg-primary-500"></span>
                <span class="text-[10px] font-bold uppercase tracking-wider text-primary-600 dark:text-primary-400">
                    System Installation Active
                </span>
            </div>
            
            <h1 class="text-4xl sm:text-5xl font-black tracking-tighter text-slate-900 dark:text-white mb-2">
                Salieno<span class="text-primary-500">.</span>
            </h1>
            <p class="text-slate-500 dark:text-slate-400 font-medium tracking-tight">Advanced Auto-Installer</p>
        </header>

        {{-- Main Wizard --}}
        <main class="flex-1 max-w-4xl mx-auto w-full flex items-start justify-center">
            {{ $slot }}
        </main>

        {{-- Footer --}}
        <footer class="max-w-4xl mx-auto w-full py-8 text-center">
            <p class="text-xs font-bold text-slate-400 dark:text-slate-600 uppercase tracking-widest">
                &copy; {{ date('Y') }} Salieno Project • Professional Hosting Automation
            </p>
        </footer>
    </div>

    {{-- Global Notification System (Alpine.js) --}}
    <div x-data="{ 
            notifications: [], 
            add(n) { 
                this.notifications.push({ ...n, id: Date.now() }); 
                setTimeout(() => { this.notifications = this.notifications.filter(i => i.id !== n.id) }, 5000); 
            } 
        }" 
        @notify.window="add($event.detail[0])"
        class="fixed top-6 right-6 z-[100] flex flex-col gap-3 w-80 pointer-events-none">
        <template x-for="n in notifications" :key="n.id">
            <div x-transition:enter="transition ease-out duration-300"
                 x-transition:enter-start="opacity-0 translate-x-12"
                 x-transition:enter-end="opacity-100 translate-x-0"
                 x-transition:leave="transition ease-in duration-200"
                 x-transition:leave-start="opacity-100 translate-x-0"
                 x-transition:leave-end="opacity-0 translate-x-12"
                 class="pointer-events-auto p-4 rounded-2xl border backdrop-blur-3xl shadow-2xl flex items-center gap-4"
                 :class="{
                     'bg-green-500/10 border-green-500/20 text-green-500': n.type === 'success',
                     'bg-red-500/10 border-red-500/20 text-red-500': n.type === 'error',
                     'bg-primary-500/10 border-primary-500/20 text-primary-500': n.type === 'info'
                 }">
                 <div class="flex-shrink-0 w-8 h-8 rounded-full flex items-center justify-center bg-white/10">
                    <i class="ph-bold" :class="{
                        'ph-check-circle': n.type === 'success',
                        'ph-warning-circle': n.type === 'error',
                        'ph-info': n.type === 'info'
                    }"></i>
                 </div>
                 <div class="flex-1">
                    <p class="text-[10px] font-black uppercase tracking-widest opacity-50" x-text="n.type"></p>
                    <p class="text-xs font-bold text-white leading-tight" x-text="n.message"></p>
                 </div>
            </div>
        </template>
    </div>

    @livewireScripts
</body>
</html>

