<div>
    <h3 class="text-xl font-semibold text-white">@lang('Forgot your password?')</h3>
    <p class="mt-1 text-sm text-slate-500">@lang('Enter your email address and we\'ll send you a verification code.')</p>

    @if (session('success'))
        <div class="mt-5 p-3.5 rounded-xl bg-emerald-500/10 border border-emerald-500/20">
            <p class="text-sm text-emerald-400">{{ session('success') }}</p>
        </div>
    @endif

    @if (!$codeSent)
        <form wire:submit="sendCode" class="mt-7 space-y-5">
            <!-- Email -->
            <div>
                <label for="email" class="block text-sm font-medium text-slate-400 mb-2">
                    @lang('Email Address')
                </label>
                <input
                    wire:model="email"
                    id="email"
                    type="email"
                    autocomplete="email"
                    class="block w-full rounded-xl border border-white/[0.08] bg-white/[0.04] py-3 px-4 text-white placeholder:text-slate-600 focus:border-indigo-500/50 focus:bg-white/[0.06] focus:outline-none focus:ring-2 focus:ring-indigo-500/20 sm:text-sm transition-all"
                    placeholder="@lang('Enter your email address')"
                >
                @error('email')
                    <p class="mt-2 text-sm text-red-400">{{ $message }}</p>
                @enderror
            </div>

            <!-- Submit -->
            <button
                type="submit"
                class="flex w-full justify-center items-center gap-2 rounded-xl bg-indigo-600 px-4 py-3 text-sm font-semibold text-white shadow-lg shadow-indigo-600/20 hover:bg-indigo-500 focus:outline-none focus:ring-2 focus:ring-indigo-500/50 focus:ring-offset-2 focus:ring-offset-[#0a0a0f] transition-all duration-200 disabled:opacity-50 disabled:cursor-not-allowed"
                wire:loading.attr="disabled"
            >
                <span wire:loading.remove wire:target="sendCode">
                    <i class="ph-bold ph-paper-plane-right text-base mr-1"></i>
                    @lang('Send Verification Code')
                </span>
                <span wire:loading wire:target="sendCode" class="flex items-center gap-2">
                    <svg class="animate-spin h-4 w-4" fill="none" viewBox="0 0 24 24">
                        <circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle>
                        <path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z"></path>
                    </svg>
                    @lang('Sending...')
                </span>
            </button>
        </form>
    @else
        <div class="mt-7 text-center">
            <div class="w-14 h-14 mx-auto bg-emerald-500/10 rounded-2xl flex items-center justify-center mb-4 border border-emerald-500/20">
                <i class="ph-duotone ph-envelope-simple text-2xl text-emerald-400"></i>
            </div>
            <p class="text-slate-300 mb-4">@lang('Verification code sent to') <strong class="text-white">{{ $email }}</strong></p>
            <a href="{{ route('admin.password.verify') }}" class="inline-flex items-center gap-2 text-indigo-400 hover:text-indigo-300 font-medium transition-colors text-sm">
                @lang('Enter verification code')
                <i class="ph-bold ph-arrow-right text-sm"></i>
            </a>
        </div>
    @endif

    <!-- Back to login -->
    <div class="mt-6 text-center">
        <a href="{{ route('admin.login') }}" class="inline-flex items-center gap-1.5 text-sm text-slate-500 hover:text-white transition-colors">
            <i class="ph-bold ph-arrow-left text-xs"></i>
            @lang('Back to login')
        </a>
    </div>
</div>
