<div>
    <h3 class="text-xl font-semibold text-white">@lang('Sign in to your account')</h3>
    <p class="mt-1 text-sm text-slate-500">@lang('Enter your credentials to access the admin panel.')</p>

    @if (session('success'))
        <div class="mt-5 p-3.5 rounded-xl bg-emerald-500/10 border border-emerald-500/20">
            <p class="text-sm text-emerald-400">{{ session('success') }}</p>
        </div>
    @endif

    @if (session('error'))
        <div class="mt-5 p-3.5 rounded-xl bg-red-500/10 border border-red-500/20">
            <p class="text-sm text-red-400">{{ session('error') }}</p>
        </div>
    @endif

    <form wire:submit="login" class="mt-7 space-y-5">
        <!-- Username/Email -->
        <div>
            <label for="username" class="block text-sm font-medium text-slate-400 mb-2">
                @lang('Username or Email')
            </label>
            <input
                wire:model="username"
                id="username"
                type="text"
                autocomplete="username"
                class="block w-full rounded-xl border border-white/[0.08] bg-white/[0.04] py-3 px-4 text-white placeholder:text-slate-600 focus:border-indigo-500/50 focus:bg-white/[0.06] focus:outline-none focus:ring-2 focus:ring-indigo-500/20 sm:text-sm transition-all"
                placeholder="@lang('admin@example.com')"
            >
            @error('username')
                <p class="mt-2 text-sm text-red-400">{{ $message }}</p>
            @enderror
        </div>

        <!-- Password -->
        <div>
            <label for="password" class="block text-sm font-medium text-slate-400 mb-2">
                @lang('Password')
            </label>
            <input
                wire:model="password"
                id="password"
                type="password"
                autocomplete="current-password"
                class="block w-full rounded-xl border border-white/[0.08] bg-white/[0.04] py-3 px-4 text-white placeholder:text-slate-600 focus:border-indigo-500/50 focus:bg-white/[0.06] focus:outline-none focus:ring-2 focus:ring-indigo-500/20 sm:text-sm transition-all"
                placeholder="••••••••"
            >
            @error('password')
                <p class="mt-2 text-sm text-red-400">{{ $message }}</p>
            @enderror
        </div>

        <!-- Remember & Forgot -->
        <div class="flex items-center justify-between">
            <div class="flex items-center">
                <input
                    wire:model="remember"
                    id="remember"
                    type="checkbox"
                    class="h-4 w-4 rounded border-white/10 bg-white/5 text-indigo-500 focus:ring-indigo-500/30 focus:ring-offset-0"
                >
                <label for="remember" class="ml-2 block text-sm text-slate-500">
                    @lang('Remember me')
                </label>
            </div>

            <a href="{{ route('admin.password.request') }}" class="text-sm font-medium text-indigo-400 hover:text-indigo-300 transition-colors">
                @lang('Forgot password?')
            </a>
        </div>

        <!-- Submit -->
        <button
            type="submit"
            class="flex w-full justify-center items-center gap-2 rounded-xl bg-indigo-600 px-4 py-3 text-sm font-semibold text-white shadow-lg shadow-indigo-600/20 hover:bg-indigo-500 focus:outline-none focus:ring-2 focus:ring-indigo-500/50 focus:ring-offset-2 focus:ring-offset-[#0a0a0f] transition-all duration-200 disabled:opacity-50 disabled:cursor-not-allowed"
            wire:loading.attr="disabled"
        >
            <span wire:loading.remove wire:target="login">
                <i class="ph-bold ph-sign-in text-base mr-1"></i>
                @lang('Sign in')
            </span>
            <span wire:loading wire:target="login" class="flex items-center gap-2">
                <svg class="animate-spin h-4 w-4" fill="none" viewBox="0 0 24 24">
                    <circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle>
                    <path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z"></path>
                </svg>
                @lang('Signing in...')
            </span>
        </button>
    </form>

    @if(config('app.demo_mode'))
        <div class="mt-5 p-4 rounded-xl bg-indigo-500/10 border border-indigo-500/20">
            <div class="flex items-center gap-2 mb-3">
                <i class="ph-bold ph-info text-indigo-400"></i>
                <span class="text-sm font-semibold text-indigo-400">@lang('Demo Credentials')</span>
            </div>
            <div class="space-y-1.5 text-sm">
                <div class="flex items-center justify-between">
                    <span class="text-slate-500">@lang('Email'):</span>
                    <span class="text-slate-300 font-mono text-xs">admin@example.com</span>
                </div>
                <div class="flex items-center justify-between">
                    <span class="text-slate-500">@lang('Password'):</span>
                    <span class="text-slate-300 font-mono text-xs">password</span>
                </div>
            </div>
            <button
                type="button"
                x-data
                x-on:click="
                    $wire.set('username', 'admin@example.com');
                    $wire.set('password', 'password');
                "
                class="mt-3 flex w-full justify-center items-center gap-2 rounded-lg bg-indigo-500/20 px-3 py-2 text-xs font-semibold text-indigo-300 hover:bg-indigo-500/30 transition-all"
            >
                <i class="ph-bold ph-sign-in"></i>
                @lang('Use Demo Credentials')
            </button>
        </div>
    @endif
</div>
