<div>
    <h3 class="text-xl font-semibold text-white">@lang('Reset your password')</h3>
    <p class="mt-1 text-sm text-slate-500">@lang('Enter your new password below.')</p>

    <form wire:submit="resetPassword" class="mt-7 space-y-5">
        <!-- New Password -->
        <div>
            <label for="password" class="block text-sm font-medium text-slate-400 mb-2">
                @lang('New Password')
            </label>
            <input
                wire:model="password"
                id="password"
                type="password"
                autocomplete="new-password"
                class="block w-full rounded-xl border border-white/[0.08] bg-white/[0.04] py-3 px-4 text-white placeholder:text-slate-600 focus:border-indigo-500/50 focus:bg-white/[0.06] focus:outline-none focus:ring-2 focus:ring-indigo-500/20 sm:text-sm transition-all"
                placeholder="@lang('Enter new password')"
            >
            @error('password')
                <p class="mt-2 text-sm text-red-400">{{ $message }}</p>
            @enderror
        </div>

        <!-- Confirm Password -->
        <div>
            <label for="password_confirmation" class="block text-sm font-medium text-slate-400 mb-2">
                @lang('Confirm Password')
            </label>
            <input
                wire:model="password_confirmation"
                id="password_confirmation"
                type="password"
                autocomplete="new-password"
                class="block w-full rounded-xl border border-white/[0.08] bg-white/[0.04] py-3 px-4 text-white placeholder:text-slate-600 focus:border-indigo-500/50 focus:bg-white/[0.06] focus:outline-none focus:ring-2 focus:ring-indigo-500/20 sm:text-sm transition-all"
                placeholder="@lang('Confirm new password')"
            >
        </div>

        <!-- Password Requirements -->
        <div class="rounded-xl bg-white/[0.03] p-4 border border-white/[0.06]">
            <p class="text-xs font-medium text-slate-400 mb-2">@lang('Password requirements:')</p>
            <ul class="text-xs text-slate-500 space-y-1.5">
                <li class="flex items-center gap-2">
                    <i class="ph-bold {{ strlen($password) >= 8 ? 'ph-check-circle text-emerald-400' : 'ph-circle text-slate-600' }} text-sm"></i>
                    @lang('At least 8 characters')
                </li>
            </ul>
        </div>

        <!-- Submit -->
        <button
            type="submit"
            class="flex w-full justify-center items-center gap-2 rounded-xl bg-indigo-600 px-4 py-3 text-sm font-semibold text-white shadow-lg shadow-indigo-600/20 hover:bg-indigo-500 focus:outline-none focus:ring-2 focus:ring-indigo-500/50 focus:ring-offset-2 focus:ring-offset-[#0a0a0f] transition-all duration-200 disabled:opacity-50 disabled:cursor-not-allowed"
            wire:loading.attr="disabled"
        >
            <span wire:loading.remove wire:target="resetPassword">
                <i class="ph-bold ph-lock-key text-base mr-1"></i>
                @lang('Reset Password')
            </span>
            <span wire:loading wire:target="resetPassword" class="flex items-center gap-2">
                <svg class="animate-spin h-4 w-4" fill="none" viewBox="0 0 24 24">
                    <circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle>
                    <path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z"></path>
                </svg>
                @lang('Resetting...')
            </span>
        </button>
    </form>

    <!-- Back to login -->
    <div class="mt-6 text-center">
        <a href="{{ route('admin.login') }}" class="inline-flex items-center gap-1.5 text-sm text-slate-500 hover:text-white transition-colors">
            <i class="ph-bold ph-arrow-left text-xs"></i>
            @lang('Back to login')
        </a>
    </div>
</div>
