<div>
    <div class="text-center mb-7">
        <div class="w-14 h-14 mx-auto bg-indigo-500/10 rounded-2xl flex items-center justify-center mb-4 border border-indigo-500/20">
            <i class="ph-duotone ph-shield-check text-2xl text-indigo-400"></i>
        </div>
        <h3 class="text-xl font-semibold text-white">@lang('Two-Factor Authentication')</h3>
        <p class="mt-1 text-sm text-slate-500">@lang('Enter the 6-digit code from your authenticator app.')</p>
    </div>

    <form wire:submit="verify" class="space-y-5">
        <!-- Code -->
        <div>
            <label for="code" class="block text-sm font-medium text-slate-400 mb-2">
                @lang('Authentication Code')
            </label>
            <input
                wire:model="code"
                id="code"
                type="text"
                maxlength="6"
                autofocus
                class="block w-full rounded-xl border border-white/[0.08] bg-white/[0.04] py-3.5 px-4 text-white text-center text-2xl tracking-[0.5em] font-mono placeholder:text-slate-600 focus:border-indigo-500/50 focus:bg-white/[0.06] focus:outline-none focus:ring-2 focus:ring-indigo-500/20 transition-all"
                placeholder="000000"
            >
            @error('code')
                <p class="mt-2 text-sm text-red-400">{{ $message }}</p>
            @enderror
        </div>

        <!-- Submit -->
        <button
            type="submit"
            class="flex w-full justify-center items-center gap-2 rounded-xl bg-indigo-600 px-4 py-3 text-sm font-semibold text-white shadow-lg shadow-indigo-600/20 hover:bg-indigo-500 focus:outline-none focus:ring-2 focus:ring-indigo-500/50 focus:ring-offset-2 focus:ring-offset-[#0a0a0f] transition-all duration-200 disabled:opacity-50 disabled:cursor-not-allowed"
            wire:loading.attr="disabled"
        >
            <span wire:loading.remove wire:target="verify">
                <i class="ph-bold ph-check-circle text-base mr-1"></i>
                @lang('Verify')
            </span>
            <span wire:loading wire:target="verify" class="flex items-center gap-2">
                <svg class="animate-spin h-4 w-4" fill="none" viewBox="0 0 24 24">
                    <circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle>
                    <path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z"></path>
                </svg>
                @lang('Verifying...')
            </span>
        </button>
    </form>

    <!-- Cancel -->
    <div class="mt-6 text-center">
        <button wire:click="cancel" class="inline-flex items-center gap-1.5 text-sm text-slate-500 hover:text-white transition-colors">
            <i class="ph-bold ph-arrow-left text-xs"></i>
            @lang('Cancel and return to login')
        </button>
    </div>
</div>
