<div>
    {{-- Page Header --}}
    <x-admin.page-header :title="__('Coupons')" :subtitle="__('Manage discount coupons for products and services')">
        <x-slot:actions>
            <x-admin.button wire:click="openCreateModal" icon="ph-plus">
                @lang('Add Coupon')
            </x-admin.button>
        </x-slot:actions>
    </x-admin.page-header>

    {{-- Flash Messages --}}
    @if(session('success'))
        <x-admin.alert type="success" class="mt-6">{{ session('success') }}</x-admin.alert>
    @endif
    @if(session('error'))
        <x-admin.alert type="danger" class="mt-6">{{ session('error') }}</x-admin.alert>
    @endif

    {{-- Filters --}}
    <x-admin.card class="mt-6">
        <div class="flex flex-col gap-4 sm:flex-row sm:items-center sm:justify-between">
            <div class="flex flex-1 gap-3">
                <x-admin.input wire:model.live.debounce.300ms="search" :placeholder="__('Search by name or code...')" class="max-w-xs" />
                <x-admin.select wire:model.live="statusFilter" class="w-40">
                    <option value="">@lang('All Status')</option>
                    <option value="1">@lang('Active')</option>
                    <option value="0">@lang('Inactive')</option>
                </x-admin.select>
            </div>
        </div>
    </x-admin.card>

    {{-- Coupons Table --}}
    <x-admin.card class="mt-6">
        <div class="overflow-x-auto">
            <table class="w-full">
                <thead>
                    <tr class="border-b border-white/5 text-left text-xs font-medium uppercase tracking-wider text-slate-400">
                        <th class="px-4 py-3">@lang('Name')</th>
                        <th class="px-4 py-3">@lang('Code')</th>
                        <th class="px-4 py-3">@lang('Discount')</th>
                        <th class="px-4 py-3">@lang('Usage')</th>
                        <th class="px-4 py-3">@lang('Valid Period')</th>
                        <th class="px-4 py-3">@lang('Status')</th>
                        <th class="px-4 py-3 text-right">@lang('Actions')</th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-white/5">
                    @forelse($coupons as $coupon)
                        <tr class="transition-colors hover:bg-white/5">
                            <td class="px-4 py-4">
                                <span class="font-medium text-white">{{ $coupon->name }}</span>
                            </td>
                            <td class="px-4 py-4">
                                <code class="rounded-lg bg-indigo-500/10 px-2 py-1 text-xs font-mono text-indigo-400">{{ $coupon->code }}</code>
                            </td>
                            <td class="px-4 py-4">
                                @if($coupon->type === 1)
                                    <span class="font-semibold text-emerald-400">${{ number_format($coupon->amount, 2) }}</span>
                                    <span class="text-xs text-slate-500">@lang('Fixed')</span>
                                @else
                                    <span class="font-semibold text-emerald-400">{{ number_format($coupon->amount, 0) }}%</span>
                                    <span class="text-xs text-slate-500">@lang('Off')</span>
                                @endif
                            </td>
                            <td class="px-4 py-4">
                                <div class="flex items-center gap-2">
                                    <span class="text-white">{{ $coupon->uses }}</span>
                                    <span class="text-slate-500">/</span>
                                    <span class="text-slate-400">{{ $coupon->max_uses ?: '∞' }}</span>
                                </div>
                                @if($coupon->orders_count > 0)
                                    <span class="text-xs text-slate-500">{{ $coupon->orders_count }} @lang('orders')</span>
                                @endif
                            </td>
                            <td class="px-4 py-4 text-sm text-slate-400">
                                @if($coupon->start_date || $coupon->end_date)
                                    <div class="flex flex-col gap-0.5">
                                        @if($coupon->start_date)
                                            <span>@lang('From'): {{ \Carbon\Carbon::parse($coupon->start_date)->format('M d, Y') }}</span>
                                        @endif
                                        @if($coupon->end_date)
                                            <span>@lang('To'): {{ \Carbon\Carbon::parse($coupon->end_date)->format('M d, Y') }}</span>
                                        @endif
                                    </div>
                                @else
                                    <span class="text-slate-500">@lang('No limit')</span>
                                @endif
                            </td>
                            <td class="px-4 py-4">
                                <button wire:click="toggleStatus({{ $coupon->id }})" class="cursor-pointer">
                                    @if($coupon->status)
                                        <span class="inline-flex items-center gap-1.5 rounded-full bg-emerald-500/10 px-2.5 py-1 text-xs font-medium text-emerald-400">
                                            <span class="h-1.5 w-1.5 rounded-full bg-emerald-400"></span>
                                            @lang('Active')
                                        </span>
                                    @else
                                        <span class="inline-flex items-center gap-1.5 rounded-full bg-slate-500/10 px-2.5 py-1 text-xs font-medium text-slate-400">
                                            <span class="h-1.5 w-1.5 rounded-full bg-slate-400"></span>
                                            @lang('Inactive')
                                        </span>
                                    @endif
                                </button>
                            </td>
                            <td class="px-4 py-4">
                                <div class="flex items-center justify-end gap-2">
                                    <x-admin.button variant="ghost" size="sm" wire:click="openEditModal({{ $coupon->id }})" icon="ph-pencil-simple" />
                                    <x-admin.button variant="ghost" size="sm" wire:click="confirmDelete({{ $coupon->id }})" icon="ph-trash" class="text-rose-400 hover:text-rose-300" />
                                </div>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="7" class="px-4 py-12 text-center">
                                <div class="flex flex-col items-center gap-3">
                                    <i class="ph-duotone ph-ticket text-4xl text-slate-500"></i>
                                    <p class="text-slate-400">@lang('No coupons found')</p>
                                    <x-admin.button variant="secondary" wire:click="openCreateModal" icon="ph-plus">
                                        @lang('Create Your First Coupon')
                                    </x-admin.button>
                                </div>
                            </td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>

        @if($coupons->hasPages())
            <div class="mt-6 border-t border-white/5 pt-4">
                {{ $coupons->links() }}
            </div>
        @endif
    </x-admin.card>

    {{-- Create/Edit Modal --}}
    <x-admin.modal wire:model="showModal" :title="$isEditing ? __('Edit Coupon') : __('Create Coupon')" maxWidth="lg">
        <div class="space-y-5">
            <div class="grid grid-cols-1 gap-5 sm:grid-cols-2">
                <x-admin.input :label="__('Coupon Name')" wire:model="name" :placeholder="__('e.g. Summer Sale')" required />
                <div>
                    <div class="mb-2 flex items-center justify-between">
                        <label class="text-sm font-medium text-slate-300">@lang('Coupon Code') <span class="text-rose-400">*</span></label>
                        <button type="button" wire:click="generateCode" class="text-xs text-indigo-400 hover:text-indigo-300 transition-colors cursor-pointer">@lang('Generate')</button>
                    </div>
                    <x-admin.input wire:model="code" :placeholder="__('e.g. SUMMER20')" />
                </div>
            </div>

            <div class="grid grid-cols-1 gap-5 sm:grid-cols-2">
                <x-admin.select :label="__('Discount Type')" wire:model.live="type" required>
                    <option value="1">@lang('Fixed Amount') ($)</option>
                    <option value="2">@lang('Percentage') (%)</option>
                </x-admin.select>
                <x-admin.input type="number" step="0.01" :label="$type == 1 ? __('Discount Amount') . ' ($)' : __('Discount Percentage') . ' (%)'" wire:model="amount" required />
            </div>

            <div class="grid grid-cols-1 gap-5 sm:grid-cols-2">
                <x-admin.select :label="__('Apply Discount')" wire:model="apply_once">
                    <option value="0">@lang('On Every Renewal')</option>
                    <option value="1">@lang('First Payment Only')</option>
                </x-admin.select>
                <x-admin.input type="number" :label="__('Max Uses')" wire:model="max_uses" :placeholder="__('0 = Unlimited')" :helper="__('0 means unlimited usage')" />
            </div>

            <div class="grid grid-cols-1 gap-5 sm:grid-cols-2">
                <x-admin.input type="date" :label="__('Start Date')" wire:model="start_date" />
                <x-admin.input type="date" :label="__('End Date')" wire:model="end_date" />
            </div>

            <div>
                <label class="mb-2 block text-sm font-medium text-slate-300">@lang('Applicable Products')</label>
                <div class="max-h-48 overflow-y-auto rounded-xl border border-white/10 bg-white/5 p-3 space-y-2">
                    @forelse($this->products as $product)
                        <label class="flex items-center gap-3 rounded-lg p-2 hover:bg-white/5 cursor-pointer transition-colors">
                            <input type="checkbox" wire:model="selectedProducts" value="{{ $product->id }}"
                                class="h-4 w-4 rounded border-white/20 bg-white/5 text-indigo-500 focus:ring-indigo-500/20">
                            <span class="text-sm text-slate-300">{{ $product->name }}</span>
                        </label>
                    @empty
                        <p class="text-sm text-slate-500 text-center py-2">@lang('No products available')</p>
                    @endforelse
                </div>
                <p class="mt-1 text-xs text-slate-500">@lang('Leave empty to apply to all products')</p>
            </div>

            <x-admin.checkbox wire:model="status" :label="__('Active')" />
        </div>

        <x-slot:footer>
            <x-admin.button variant="ghost" wire:click="$set('showModal', false)">@lang('Cancel')</x-admin.button>
            <x-admin.button wire:click="save" wire:loading.attr="disabled" icon="ph-check">
                <span wire:loading.remove wire:target="save">{{ $isEditing ? __('Update') : __('Create') }} @lang('Coupon')</span>
                <span wire:loading wire:target="save">@lang('Saving...')</span>
            </x-admin.button>
        </x-slot:footer>
    </x-admin.modal>

    {{-- Delete Confirmation --}}
    @if($deleteId)
        <div class="fixed inset-0 z-50 flex items-center justify-center bg-black/50 backdrop-blur-sm">
            <div class="w-full max-w-md rounded-2xl border border-white/10 bg-[#1a1a2e] p-6 shadow-2xl">
                <div class="mb-4 flex items-center gap-3">
                    <div class="flex h-12 w-12 items-center justify-center rounded-full bg-rose-500/10">
                        <i class="ph-duotone ph-warning text-2xl text-rose-400"></i>
                    </div>
                    <div>
                        <h3 class="text-lg font-semibold text-white">@lang('Delete Coupon')</h3>
                        <p class="text-sm text-slate-400">@lang('This action cannot be undone.')</p>
                    </div>
                </div>
                <p class="mb-6 text-sm text-slate-300">@lang('Are you sure you want to delete this coupon? All associated data will be permanently removed.')</p>
                <div class="flex justify-end gap-3">
                    <x-admin.button variant="ghost" wire:click="cancelDelete">@lang('Cancel')</x-admin.button>
                    <x-admin.button variant="danger" wire:click="delete" icon="ph-trash">@lang('Delete')</x-admin.button>
                </div>
            </div>
        </div>
    @endif
</div>

