<div>
    @if($available)
        {{ $slot }}
    @elseif($showUpgrade && $upgradeInfo['show'])
        <div class="bg-gray-900/50 border border-gray-800 rounded-2xl p-6 backdrop-blur-sm">
            <div class="flex items-start gap-4">
                <div class="w-12 h-12 bg-gradient-to-br from-amber-500/20 to-orange-500/20 rounded-xl flex items-center justify-center shrink-0 ring-1 ring-amber-500/30">
                    <i class="ph-duotone ph-lock-key text-2xl text-amber-400"></i>
                </div>
                <div class="flex-1">
                    <h3 class="text-lg font-semibold text-white">{{ $upgradeTitle }}</h3>
                    <p class="text-gray-400 mt-1">
                        {{ $upgradeDescription ?? $upgradeInfo['message'] ?? 'This feature requires a higher plan.' }}
                    </p>

                    @if($feature)
                        <p class="text-sm text-gray-500 mt-2">
                            Feature: <span class="text-gray-400 font-medium">{{ ucwords(str_replace('_', ' ', $feature)) }}</span>
                        </p>
                    @endif

                    <div class="mt-4 flex flex-wrap gap-3">
                        <a href="{{ $upgradeInfo['upgrade_url'] ?? config('license.upgrade_url', 'https://salieno.com/pricing') }}" 
                           target="_blank" 
                           class="inline-flex items-center gap-2 px-4 py-2.5 bg-gradient-to-r from-primary-600 to-primary-700 hover:from-primary-500 hover:to-primary-600 text-white font-medium rounded-xl transition-all shadow-lg shadow-primary-500/25">
                            <i class="ph-duotone ph-arrow-circle-up text-lg"></i>
                            Upgrade to {{ ucfirst($upgradeInfo['required_tier'] ?? 'Professional') }}
                        </a>
                        <a href="{{ config('license.platform_url', 'https://salieno.com') }}/features" 
                           target="_blank" 
                           class="inline-flex items-center gap-2 px-4 py-2.5 bg-gray-800 hover:bg-gray-700 text-gray-300 font-medium rounded-xl transition-colors">
                            <i class="ph-duotone ph-list-bullets text-lg"></i>
                            Compare Plans
                        </a>
                    </div>
                </div>
            </div>

            {{-- Decorative gradient --}}
            <div class="absolute inset-0 bg-gradient-to-r from-amber-500/5 via-transparent to-orange-500/5 rounded-2xl pointer-events-none"></div>
        </div>
    @endif
</div>

