<div>
    {{-- Page Header --}}
    <x-admin.page-header :title="__('Cron Jobs')" :subtitle="__('Manage automated tasks and scheduled jobs.')">
        <x-slot name="actions">
            <button wire:click="runAll" wire:loading.attr="disabled" class="inline-flex items-center gap-2 rounded-xl border border-emerald-500/30 bg-emerald-500/10 px-4 py-2.5 text-sm font-medium text-emerald-400 transition-all hover:bg-emerald-500/20">
                <i class="ph-duotone ph-play" wire:loading.class="animate-spin" wire:target="runAll"></i>
                <span wire:loading.remove wire:target="runAll">@lang('Run All')</span>
                <span wire:loading wire:target="runAll">@lang('Running...')</span>
            </button>
            <a href="{{ route('admin.cron.schedules') }}" class="inline-flex items-center gap-2 rounded-xl border border-white/10 bg-white/5 px-4 py-2.5 text-sm font-medium text-white transition-all hover:bg-white/10">
                <i class="ph-duotone ph-clock"></i>
                @lang('Schedules')
            </a>
            <button wire:click="openAddModal" class="inline-flex items-center gap-2 rounded-xl bg-gradient-to-r from-purple-600 to-purple-700 px-4 py-2.5 text-sm font-medium text-white shadow-lg shadow-purple-500/25 transition-all hover:shadow-purple-500/40">
                <i class="ph-bold ph-plus"></i>
                @lang('Add Cron Job')
            </button>
        </x-slot>
    </x-admin.page-header>

    {{-- Stats Cards --}}
    <div class="mt-6 grid grid-cols-2 gap-4 lg:grid-cols-6">
        <x-admin.stat-card
            :title="__('Total Jobs')"
            :value="$this->totalCount"
            icon="ph-duotone ph-clock-countdown"
            color="purple"
        />
        <x-admin.stat-card
            :title="__('Running')"
            :value="$this->runningCount"
            icon="ph-duotone ph-play-circle"
            color="emerald"
        />
        <x-admin.stat-card
            :title="__('Paused')"
            :value="$this->pausedCount"
            icon="ph-duotone ph-pause-circle"
            color="slate"
        />
        <x-admin.stat-card
            :title="__('Healthy')"
            :value="$this->healthyCount"
            icon="ph-duotone ph-check-circle"
            color="emerald"
        />
        <x-admin.stat-card
            :title="__('Warning')"
            :value="$this->warningCount"
            icon="ph-duotone ph-warning"
            color="amber"
        />
        <x-admin.stat-card
            :title="__('Critical')"
            :value="$this->criticalCount"
            icon="ph-duotone ph-x-circle"
            color="rose"
        />
    </div>

    {{-- Filters --}}
    <x-admin.card class="mt-6">
        <div class="flex flex-col gap-4 sm:flex-row sm:items-center sm:justify-between">
            <div class="relative flex-1">
                <i class="ph-duotone ph-magnifying-glass absolute left-3 top-1/2 -translate-y-1/2 text-slate-400"></i>
                <input
                    type="text"
                    wire:model.live.debounce.300ms="search"
                    placeholder="{{ __('Search cron jobs...') }}"
                    class="w-full rounded-xl border border-white/10 bg-white/5 py-2.5 pl-10 pr-4 text-sm text-white placeholder-slate-400 outline-none transition-all focus:border-purple-500/50 focus:ring-2 focus:ring-purple-500/20"
                />
            </div>
            <div class="flex flex-wrap items-center gap-3">
                <select
                    wire:model.live="category"
                    class="rounded-xl border border-white/10 bg-white/5 px-4 py-2.5 text-sm text-white outline-none transition-all focus:border-purple-500/50 focus:ring-2 focus:ring-purple-500/20"
                >
                    <option value="" class="bg-[#12121a]">@lang('All Categories')</option>
                    @foreach($this->categories as $key => $label)
                        <option value="{{ $key }}" class="bg-[#12121a]">{{ $label }}</option>
                    @endforeach
                </select>
                <select
                    wire:model.live="status"
                    class="rounded-xl border border-white/10 bg-white/5 px-4 py-2.5 text-sm text-white outline-none transition-all focus:border-purple-500/50 focus:ring-2 focus:ring-purple-500/20"
                >
                    <option value="" class="bg-[#12121a]">@lang('All Status')</option>
                    <option value="running" class="bg-[#12121a]">@lang('Running')</option>
                    <option value="paused" class="bg-[#12121a]">@lang('Paused')</option>
                    <option value="healthy" class="bg-[#12121a]">@lang('Healthy')</option>
                    <option value="warning" class="bg-[#12121a]">@lang('Warning')</option>
                    <option value="critical" class="bg-[#12121a]">@lang('Critical')</option>
                    <option value="default" class="bg-[#12121a]">@lang('Default')</option>
                    <option value="custom" class="bg-[#12121a]">@lang('Custom')</option>
                </select>
            </div>
        </div>
    </x-admin.card>

    {{-- Cron Jobs Table --}}
    <x-admin.card class="mt-6 overflow-hidden">
        <div class="overflow-x-auto">
            <table class="w-full">
                <thead>
                    <tr class="border-b border-white/10 text-left text-xs font-medium uppercase tracking-wider text-slate-400">
                        <th class="px-4 py-3">@lang('Name')</th>
                        <th class="px-4 py-3">@lang('Category')</th>
                        <th class="px-4 py-3">@lang('Schedule')</th>
                        <th class="px-4 py-3">@lang('Health')</th>
                        <th class="px-4 py-3">@lang('Stats')</th>
                        <th class="px-4 py-3">@lang('Next Run')</th>
                        <th class="px-4 py-3 text-right">@lang('Actions')</th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-white/5">
                    @forelse($this->cronJobs as $cron)
                        <tr class="transition-colors hover:bg-white/5">
                            <td class="px-4 py-4">
                                <div class="flex items-center gap-3">
                                    @php
                                        $categoryColors = [
                                            'billing' => 'emerald',
                                            'notifications' => 'blue',
                                            'services' => 'purple',
                                            'affiliate' => 'amber',
                                            'maintenance' => 'slate',
                                            'custom' => 'rose',
                                        ];
                                        $color = $categoryColors[$cron->category] ?? 'slate';
                                    @endphp
                                    <div class="flex h-10 w-10 items-center justify-center rounded-xl bg-{{ $color }}-500/20 text-{{ $color }}-400">
                                        <i class="ph-duotone ph-clock-countdown text-lg"></i>
                                    </div>
                                    <div>
                                        <div class="flex items-center gap-2">
                                            <span class="font-medium text-white">{{ $cron->name }}</span>
                                            @if($cron->failure_count > 0)
                                                <span class="flex h-5 w-5 items-center justify-center rounded-full bg-rose-500/20 text-rose-400" title="@lang(':count errors', ['count' => $cron->failure_count])">
                                                    <i class="ph-bold ph-warning text-xs"></i>
                                                </span>
                                            @endif
                                            @if($cron->priority == 1)
                                                <span class="flex h-5 items-center justify-center rounded bg-amber-500/20 px-1.5 text-amber-400" title="@lang('High Priority')">
                                                    <i class="ph-bold ph-star text-xs"></i>
                                                </span>
                                            @endif
                                        </div>
                                        <div class="flex items-center gap-2 mt-0.5">
                                            <code class="text-xs text-slate-500">{{ $cron->alias }}</code>
                                            @if(!$cron->is_running)
                                                <span class="text-xs text-slate-500">• @lang('Paused')</span>
                                            @endif
                                        </div>
                                    </div>
                                </div>
                            </td>
                            <td class="px-4 py-4">
                                <span class="inline-flex items-center gap-1.5 rounded-lg border border-{{ $color }}-500/20 bg-{{ $color }}-500/10 px-2 py-1 text-xs font-medium text-{{ $color }}-400">
                                    {{ $cron->category_label }}
                                </span>
                            </td>
                            <td class="px-4 py-4">
                                <span class="inline-flex items-center gap-1.5 rounded-lg border border-purple-500/20 bg-purple-500/10 px-2 py-1 text-xs font-medium text-purple-400">
                                    <i class="ph-duotone ph-timer"></i>
                                    {{ $cron->schedule?->name ?? __('No Schedule') }}
                                </span>
                            </td>
                            <td class="px-4 py-4">
                                @php
                                    $health = $cron->health_status;
                                    $healthColors = [
                                        'healthy' => 'emerald',
                                        'warning' => 'amber',
                                        'critical' => 'rose',
                                    ];
                                    $healthColor = $healthColors[$health] ?? 'slate';
                                    $healthIcons = [
                                        'healthy' => 'ph-check-circle',
                                        'warning' => 'ph-warning',
                                        'critical' => 'ph-x-circle',
                                    ];
                                    $healthIcon = $healthIcons[$health] ?? 'ph-question';
                                @endphp
                                <span class="inline-flex items-center gap-1.5 rounded-lg border border-{{ $healthColor }}-500/20 bg-{{ $healthColor }}-500/10 px-2 py-1 text-xs font-medium text-{{ $healthColor }}-400">
                                    <i class="ph-duotone {{ $healthIcon }}"></i>
                                    {{ ucfirst($health) }}
                                </span>
                            </td>
                            <td class="px-4 py-4">
                                <div class="space-y-1">
                                    <div class="flex items-center gap-2 text-xs">
                                        <span class="text-slate-400">@lang('Success'):</span>
                                        <span class="font-medium {{ $cron->success_rate >= 80 ? 'text-emerald-400' : ($cron->success_rate >= 50 ? 'text-amber-400' : 'text-rose-400') }}">{{ $cron->success_rate }}%</span>
                                    </div>
                                    <div class="flex items-center gap-2 text-xs">
                                        <span class="text-slate-400">@lang('Avg'):</span>
                                        <span class="font-medium text-white">{{ $cron->formatted_duration }}</span>
                                    </div>
                                    <div class="flex items-center gap-3 text-xs text-slate-500">
                                        <span>{{ $cron->success_count ?? 0 }} ✓</span>
                                        <span>{{ $cron->failure_count ?? 0 }} ✗</span>
                                        @if($cron->depends_on && count($cron->depends_on) > 0)
                                            <span class="inline-flex items-center gap-1 text-blue-400" title="@lang('Has :count dependencies', ['count' => count($cron->depends_on)])">
                                                <i class="ph-duotone ph-git-branch"></i>
                                                {{ count($cron->depends_on) }}
                                            </span>
                                        @endif
                                    </div>
                                </div>
                            </td>
                            <td class="px-4 py-4">
                                @if($cron->next_run)
                                    <div class="text-sm text-white">{{ $cron->next_run->format('M d, H:i') }}</div>
                                    @if($cron->next_run->isFuture())
                                        <div class="text-xs text-slate-400">{{ $cron->next_run->diffForHumans() }}</div>
                                    @else
                                        <div class="text-xs text-amber-400">@lang('Overdue')</div>
                                    @endif
                                    @if($cron->last_run)
                                        <div class="text-xs text-slate-500 mt-1">@lang('Last'): {{ $cron->last_run->diffForHumans() }}</div>
                                    @endif
                                @else
                                    <span class="text-sm text-slate-500">--</span>
                                @endif
                            </td>
                            <td class="px-4 py-4">
                                <div class="flex items-center justify-end gap-1">
                                    {{-- Run Now --}}
                                    <button
                                        wire:click="runNow({{ $cron->id }})"
                                        wire:loading.attr="disabled"
                                        wire:target="runNow({{ $cron->id }})"
                                        class="flex h-8 w-8 items-center justify-center rounded-lg border border-white/10 bg-white/5 text-slate-400 transition-all hover:bg-emerald-500/20 hover:text-emerald-400 hover:border-emerald-500/30"
                                        title="@lang('Run Now')"
                                    >
                                        <i class="ph-bold ph-play text-sm" wire:loading.class="animate-spin" wire:target="runNow({{ $cron->id }})"></i>
                                    </button>

                                    {{-- Pause/Resume --}}
                                    <button
                                        wire:click="toggleRunning({{ $cron->id }})"
                                        class="flex h-8 w-8 items-center justify-center rounded-lg border border-white/10 bg-white/5 text-slate-400 transition-all {{ $cron->is_running ? 'hover:bg-amber-500/20 hover:text-amber-400 hover:border-amber-500/30' : 'hover:bg-emerald-500/20 hover:text-emerald-400 hover:border-emerald-500/30' }}"
                                        title="{{ $cron->is_running ? __('Pause') : __('Resume') }}"
                                    >
                                        <i class="ph-bold {{ $cron->is_running ? 'ph-pause' : 'ph-play-circle' }} text-sm"></i>
                                    </button>

                                    {{-- View Logs --}}
                                    <button
                                        wire:click="openLogsModal({{ $cron->id }})"
                                        class="flex h-8 w-8 items-center justify-center rounded-lg border border-white/10 bg-white/5 text-slate-400 transition-all hover:bg-blue-500/20 hover:text-blue-400 hover:border-blue-500/30"
                                        title="@lang('View Logs')"
                                    >
                                        <i class="ph-bold ph-list-bullets text-sm"></i>
                                    </button>

                                    {{-- Edit --}}
                                    <button
                                        wire:click="openEditModal({{ $cron->id }})"
                                        class="flex h-8 w-8 items-center justify-center rounded-lg border border-white/10 bg-white/5 text-slate-400 transition-all hover:bg-purple-500/20 hover:text-purple-400 hover:border-purple-500/30"
                                        title="@lang('Edit')"
                                    >
                                        <i class="ph-bold ph-pencil-simple text-sm"></i>
                                    </button>

                                    {{-- Clear Errors --}}
                                    @if($cron->failure_count > 0)
                                        <button
                                            wire:click="clearJobErrors({{ $cron->id }})"
                                            class="flex h-8 w-8 items-center justify-center rounded-lg border border-white/10 bg-white/5 text-slate-400 transition-all hover:bg-amber-500/20 hover:text-amber-400 hover:border-amber-500/30"
                                            title="@lang('Clear Errors')"
                                        >
                                            <i class="ph-bold ph-eraser text-sm"></i>
                                        </button>
                                    @endif

                                    {{-- Delete (only for custom) --}}
                                    @if(!$cron->is_default)
                                        <button
                                            wire:click="openDeleteModal({{ $cron->id }})"
                                            class="flex h-8 w-8 items-center justify-center rounded-lg border border-white/10 bg-white/5 text-slate-400 transition-all hover:bg-rose-500/20 hover:text-rose-400 hover:border-rose-500/30"
                                            title="@lang('Delete')"
                                        >
                                            <i class="ph-bold ph-trash text-sm"></i>
                                        </button>
                                    @endif
                                </div>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="7" class="px-4 py-12 text-center">
                                <i class="ph-duotone ph-clock-countdown text-5xl text-slate-600"></i>
                                <p class="mt-4 text-sm font-medium text-white">@lang('No cron jobs found')</p>
                                <p class="mt-1 text-xs text-slate-400">@lang('Run the cron job seeder or add a new cron job.')</p>
                            </td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </x-admin.card>

    {{-- Cron Command Info --}}
    <x-admin.card class="mt-6">
        <div class="flex items-start gap-4">
            <div class="flex h-12 w-12 shrink-0 items-center justify-center rounded-xl bg-gradient-to-br from-blue-500/20 to-blue-600/10 text-blue-400">
                <i class="ph-duotone ph-terminal text-2xl"></i>
            </div>
            <div class="flex-1">
                <h3 class="text-sm font-semibold text-white">@lang('Cron Command')</h3>
                <p class="mt-1 text-xs text-slate-400">@lang('Add this command to your server\'s crontab to run scheduled jobs automatically.')</p>
                <div class="mt-3 flex items-center gap-2">
                    <code class="flex-1 rounded-lg border border-white/10 bg-black/30 px-4 py-2.5 text-xs text-emerald-400">
                        * * * * * cd {{ base_path() }} && php artisan schedule:run >> /dev/null 2>&1
                    </code>
                    <button
                        onclick="navigator.clipboard.writeText('* * * * * cd {{ base_path() }} && php artisan schedule:run >> /dev/null 2>&1')"
                        class="flex h-10 w-10 items-center justify-center rounded-lg border border-white/10 bg-white/5 text-slate-400 transition-all hover:bg-white/10 hover:text-white"
                        title="@lang('Copy')"
                    >
                        <i class="ph-bold ph-copy"></i>
                    </button>
                </div>
            </div>
        </div>
    </x-admin.card>

    {{-- Add Cron Job Modal --}}
    @if($showAddModal)
        <div class="fixed inset-0 z-50 flex items-center justify-center overflow-y-auto bg-black/60 backdrop-blur-sm" wire:click.self="$set('showAddModal', false)">
            <div class="relative w-full max-w-lg rounded-2xl border border-white/10 bg-[#12121a] p-6 shadow-2xl">
                <div class="mb-6 flex items-center justify-between">
                    <h3 class="text-lg font-semibold text-white">@lang('Add Custom Cron Job')</h3>
                    <button wire:click="$set('showAddModal', false)" class="flex h-8 w-8 items-center justify-center rounded-lg text-slate-400 transition-all hover:bg-white/10 hover:text-white">
                        <i class="ph-bold ph-x"></i>
                    </button>
                </div>

                <form wire:submit="store" class="space-y-4">
                    <div>
                        <label class="mb-1.5 block text-sm font-medium text-slate-300">@lang('Name') <span class="text-rose-400">*</span></label>
                        <input type="text" wire:model="name" class="w-full rounded-xl border border-white/10 bg-white/5 px-4 py-2.5 text-sm text-white placeholder-slate-400 outline-none transition-all focus:border-purple-500/50 focus:ring-2 focus:ring-purple-500/20" placeholder="@lang('Enter cron job name')">
                        @error('name') <span class="mt-1 text-xs text-rose-400">{{ $message }}</span> @enderror
                    </div>

                    <div>
                        <label class="mb-1.5 block text-sm font-medium text-slate-300">@lang('Description')</label>
                        <textarea wire:model="description" rows="2" class="w-full rounded-xl border border-white/10 bg-white/5 px-4 py-2.5 text-sm text-white placeholder-slate-400 outline-none transition-all focus:border-purple-500/50 focus:ring-2 focus:ring-purple-500/20" placeholder="@lang('What does this cron job do?')"></textarea>
                        @error('description') <span class="mt-1 text-xs text-rose-400">{{ $message }}</span> @enderror
                    </div>

                    <div class="grid grid-cols-2 gap-4">
                        <div>
                            <label class="mb-1.5 block text-sm font-medium text-slate-300">@lang('Category') <span class="text-rose-400">*</span></label>
                            <select wire:model="selectedCategory" class="w-full rounded-xl border border-white/10 bg-white/5 px-4 py-2.5 text-sm text-white outline-none transition-all focus:border-purple-500/50 focus:ring-2 focus:ring-purple-500/20">
                                @foreach($this->categories as $key => $label)
                                    <option value="{{ $key }}" class="bg-[#12121a]">{{ $label }}</option>
                                @endforeach
                            </select>
                            @error('selectedCategory') <span class="mt-1 text-xs text-rose-400">{{ $message }}</span> @enderror
                        </div>
                        <div>
                            <label class="mb-1.5 block text-sm font-medium text-slate-300">@lang('Priority') <span class="text-rose-400">*</span></label>
                            <select wire:model="priority" class="w-full rounded-xl border border-white/10 bg-white/5 px-4 py-2.5 text-sm text-white outline-none transition-all focus:border-purple-500/50 focus:ring-2 focus:ring-purple-500/20">
                                <option value="1" class="bg-[#12121a]">1 - @lang('Critical')</option>
                                <option value="2" class="bg-[#12121a]">2 - @lang('High')</option>
                                <option value="3" class="bg-[#12121a]">3 - @lang('Normal')</option>
                                <option value="4" class="bg-[#12121a]">4 - @lang('Low')</option>
                                <option value="5" class="bg-[#12121a]">5 - @lang('Background')</option>
                            </select>
                            @error('priority') <span class="mt-1 text-xs text-rose-400">{{ $message }}</span> @enderror
                        </div>
                    </div>

                    <div class="grid grid-cols-2 gap-4">
                        <div>
                            <label class="mb-1.5 block text-sm font-medium text-slate-300">@lang('Schedule') <span class="text-rose-400">*</span></label>
                            <select wire:model="cronScheduleId" class="w-full rounded-xl border border-white/10 bg-white/5 px-4 py-2.5 text-sm text-white outline-none transition-all focus:border-purple-500/50 focus:ring-2 focus:ring-purple-500/20">
                                @foreach($this->schedules as $schedule)
                                    <option value="{{ $schedule->id }}" class="bg-[#12121a]">{{ $schedule->name }}</option>
                                @endforeach
                            </select>
                            @error('cronScheduleId') <span class="mt-1 text-xs text-rose-400">{{ $message }}</span> @enderror
                        </div>
                        <div>
                            <label class="mb-1.5 block text-sm font-medium text-slate-300">@lang('Next Run') <span class="text-rose-400">*</span></label>
                            <input type="datetime-local" wire:model="nextRun" class="w-full rounded-xl border border-white/10 bg-white/5 px-4 py-2.5 text-sm text-white placeholder-slate-400 outline-none transition-all focus:border-purple-500/50 focus:ring-2 focus:ring-purple-500/20">
                            @error('nextRun') <span class="mt-1 text-xs text-rose-400">{{ $message }}</span> @enderror
                        </div>
                    </div>

                    <div>
                        <label class="mb-1.5 block text-sm font-medium text-slate-300">@lang('URL') <span class="text-rose-400">*</span></label>
                        <input type="url" wire:model="url" class="w-full rounded-xl border border-white/10 bg-white/5 px-4 py-2.5 text-sm text-white placeholder-slate-400 outline-none transition-all focus:border-purple-500/50 focus:ring-2 focus:ring-purple-500/20" placeholder="https://example.com/cron">
                        <p class="mt-1 text-xs text-slate-500">@lang('The URL that will be called when this cron job runs.')</p>
                        @error('url') <span class="mt-1 text-xs text-rose-400">{{ $message }}</span> @enderror
                    </div>

                    <div class="flex items-center gap-3 pt-4">
                        <button type="button" wire:click="$set('showAddModal', false)" class="flex-1 rounded-xl border border-white/10 bg-white/5 px-4 py-2.5 text-sm font-medium text-white transition-all hover:bg-white/10">
                            @lang('Cancel')
                        </button>
                        <button type="submit" class="flex-1 rounded-xl bg-purple-600 px-4 py-2.5 text-sm font-medium text-white shadow-lg shadow-purple-500/25 transition-all hover:bg-purple-700">
                            @lang('Create')
                        </button>
                    </div>
                </form>
            </div>
        </div>
    @endif

    {{-- Edit Cron Job Modal --}}
    @if($showEditModal)
        <div class="fixed inset-0 z-50 flex items-center justify-center overflow-y-auto bg-black/60 backdrop-blur-sm" wire:click.self="$set('showEditModal', false)">
            <div class="relative w-full max-w-lg rounded-2xl border border-white/10 bg-[#12121a] p-6 shadow-2xl">
                <div class="mb-6 flex items-center justify-between">
                    <h3 class="text-lg font-semibold text-white">@lang('Edit Cron Job')</h3>
                    <button wire:click="$set('showEditModal', false)" class="flex h-8 w-8 items-center justify-center rounded-lg text-slate-400 transition-all hover:bg-white/10 hover:text-white">
                        <i class="ph-bold ph-x"></i>
                    </button>
                </div>

                <form wire:submit="update" class="space-y-4">
                    <div>
                        <label class="mb-1.5 block text-sm font-medium text-slate-300">@lang('Name') <span class="text-rose-400">*</span></label>
                        <input type="text" wire:model="name" class="w-full rounded-xl border border-white/10 bg-white/5 px-4 py-2.5 text-sm text-white placeholder-slate-400 outline-none transition-all focus:border-purple-500/50 focus:ring-2 focus:ring-purple-500/20" placeholder="@lang('Enter cron job name')" {{ $isDefault ? 'readonly' : '' }}>
                        @error('name') <span class="mt-1 text-xs text-rose-400">{{ $message }}</span> @enderror
                    </div>

                    <div>
                        <label class="mb-1.5 block text-sm font-medium text-slate-300">@lang('Description')</label>
                        <textarea wire:model="description" rows="2" class="w-full rounded-xl border border-white/10 bg-white/5 px-4 py-2.5 text-sm text-white placeholder-slate-400 outline-none transition-all focus:border-purple-500/50 focus:ring-2 focus:ring-purple-500/20" placeholder="@lang('What does this cron job do?')"></textarea>
                        @error('description') <span class="mt-1 text-xs text-rose-400">{{ $message }}</span> @enderror
                    </div>

                    <div class="grid grid-cols-2 gap-4">
                        <div>
                            <label class="mb-1.5 block text-sm font-medium text-slate-300">@lang('Category') <span class="text-rose-400">*</span></label>
                            <select wire:model="selectedCategory" class="w-full rounded-xl border border-white/10 bg-white/5 px-4 py-2.5 text-sm text-white outline-none transition-all focus:border-purple-500/50 focus:ring-2 focus:ring-purple-500/20">
                                @foreach($this->categories as $key => $label)
                                    <option value="{{ $key }}" class="bg-[#12121a]">{{ $label }}</option>
                                @endforeach
                            </select>
                            @error('selectedCategory') <span class="mt-1 text-xs text-rose-400">{{ $message }}</span> @enderror
                        </div>
                        <div>
                            <label class="mb-1.5 block text-sm font-medium text-slate-300">@lang('Priority') <span class="text-rose-400">*</span></label>
                            <select wire:model="priority" class="w-full rounded-xl border border-white/10 bg-white/5 px-4 py-2.5 text-sm text-white outline-none transition-all focus:border-purple-500/50 focus:ring-2 focus:ring-purple-500/20">
                                <option value="1" class="bg-[#12121a]">1 - @lang('Critical')</option>
                                <option value="2" class="bg-[#12121a]">2 - @lang('High')</option>
                                <option value="3" class="bg-[#12121a]">3 - @lang('Normal')</option>
                                <option value="4" class="bg-[#12121a]">4 - @lang('Low')</option>
                                <option value="5" class="bg-[#12121a]">5 - @lang('Background')</option>
                            </select>
                            @error('priority') <span class="mt-1 text-xs text-rose-400">{{ $message }}</span> @enderror
                        </div>
                    </div>

                    <div class="grid grid-cols-2 gap-4">
                        <div>
                            <label class="mb-1.5 block text-sm font-medium text-slate-300">@lang('Schedule') <span class="text-rose-400">*</span></label>
                            <select wire:model="cronScheduleId" class="w-full rounded-xl border border-white/10 bg-white/5 px-4 py-2.5 text-sm text-white outline-none transition-all focus:border-purple-500/50 focus:ring-2 focus:ring-purple-500/20">
                                @foreach($this->schedules as $schedule)
                                    <option value="{{ $schedule->id }}" class="bg-[#12121a]">{{ $schedule->name }}</option>
                                @endforeach
                            </select>
                            @error('cronScheduleId') <span class="mt-1 text-xs text-rose-400">{{ $message }}</span> @enderror
                        </div>
                        <div>
                            <label class="mb-1.5 block text-sm font-medium text-slate-300">@lang('Next Run') <span class="text-rose-400">*</span></label>
                            <input type="datetime-local" wire:model="nextRun" class="w-full rounded-xl border border-white/10 bg-white/5 px-4 py-2.5 text-sm text-white placeholder-slate-400 outline-none transition-all focus:border-purple-500/50 focus:ring-2 focus:ring-purple-500/20">
                            @error('nextRun') <span class="mt-1 text-xs text-rose-400">{{ $message }}</span> @enderror
                        </div>
                    </div>

                    @if(!$isDefault)
                        <div>
                            <label class="mb-1.5 block text-sm font-medium text-slate-300">@lang('URL') <span class="text-rose-400">*</span></label>
                            <input type="url" wire:model="url" class="w-full rounded-xl border border-white/10 bg-white/5 px-4 py-2.5 text-sm text-white placeholder-slate-400 outline-none transition-all focus:border-purple-500/50 focus:ring-2 focus:ring-purple-500/20" placeholder="https://example.com/cron">
                            @error('url') <span class="mt-1 text-xs text-rose-400">{{ $message }}</span> @enderror
                        </div>
                    @endif

                    {{-- Dependencies Section --}}
                    <div class="border-t border-white/10 pt-4 mt-4">
                        <label class="mb-2 block text-sm font-medium text-slate-300">@lang('Dependencies')</label>
                        <p class="text-xs text-slate-500 mb-3">@lang('Select jobs that must complete before this job runs.')</p>
                        <div class="max-h-32 overflow-y-auto space-y-2 rounded-xl border border-white/10 bg-white/5 p-3">
                            @foreach($this->allCronJobs as $job)
                                @if($job->id !== $editingId)
                                    <label class="flex items-center gap-2 cursor-pointer hover:bg-white/5 rounded-lg p-1.5 transition-all">
                                        <input type="checkbox" wire:model="dependsOn" value="{{ $job->id }}" class="rounded border-white/20 bg-white/10 text-purple-500 focus:ring-purple-500/50">
                                        <span class="text-sm text-white">{{ $job->name }}</span>
                                    </label>
                                @endif
                            @endforeach
                        </div>
                        @error('dependsOn') <span class="mt-1 text-xs text-rose-400">{{ $message }}</span> @enderror
                    </div>

                    {{-- Execution Settings --}}
                    <div class="grid grid-cols-3 gap-4">
                        <div>
                            <label class="mb-1.5 block text-sm font-medium text-slate-300">@lang('Group')</label>
                            <input type="text" wire:model="executionGroup" class="w-full rounded-xl border border-white/10 bg-white/5 px-4 py-2.5 text-sm text-white placeholder-slate-400 outline-none transition-all focus:border-purple-500/50 focus:ring-2 focus:ring-purple-500/20" placeholder="@lang('e.g. billing')">
                        </div>
                        <div>
                            <label class="mb-1.5 block text-sm font-medium text-slate-300">@lang('Retries')</label>
                            <input type="number" wire:model="maxRetries" min="0" max="10" class="w-full rounded-xl border border-white/10 bg-white/5 px-4 py-2.5 text-sm text-white placeholder-slate-400 outline-none transition-all focus:border-purple-500/50 focus:ring-2 focus:ring-purple-500/20">
                        </div>
                        <div>
                            <label class="mb-1.5 block text-sm font-medium text-slate-300">@lang('Timeout')</label>
                            <input type="number" wire:model="timeout" min="30" max="3600" class="w-full rounded-xl border border-white/10 bg-white/5 px-4 py-2.5 text-sm text-white placeholder-slate-400 outline-none transition-all focus:border-purple-500/50 focus:ring-2 focus:ring-purple-500/20">
                        </div>
                    </div>

                    <div class="flex items-center gap-3 pt-4">
                        <button type="button" wire:click="$set('showEditModal', false)" class="flex-1 rounded-xl border border-white/10 bg-white/5 px-4 py-2.5 text-sm font-medium text-white transition-all hover:bg-white/10">
                            @lang('Cancel')
                        </button>
                        <button type="submit" class="flex-1 rounded-xl bg-purple-600 px-4 py-2.5 text-sm font-medium text-white shadow-lg shadow-purple-500/25 transition-all hover:bg-purple-700">
                            @lang('Update')
                        </button>
                    </div>
                </form>
            </div>
        </div>
    @endif

    {{-- Delete Confirmation Modal --}}
    @if($showDeleteModal)
        <div class="fixed inset-0 z-50 flex items-center justify-center overflow-y-auto bg-black/60 backdrop-blur-sm" wire:click.self="$set('showDeleteModal', false)">
            <div class="relative w-full max-w-md rounded-2xl border border-white/10 bg-[#12121a] p-6 shadow-2xl">
                <div class="mb-6 text-center">
                    <div class="mx-auto mb-4 flex h-16 w-16 items-center justify-center rounded-full bg-rose-500/20 text-rose-400">
                        <i class="ph-duotone ph-trash text-3xl"></i>
                    </div>
                    <h3 class="text-lg font-semibold text-white">@lang('Delete Cron Job')</h3>
                    <p class="mt-2 text-sm text-slate-400">@lang('Are you sure you want to delete this cron job? This action cannot be undone.')</p>
                </div>

                <div class="flex items-center gap-3">
                    <button wire:click="$set('showDeleteModal', false)" class="flex-1 rounded-xl border border-white/10 bg-white/5 px-4 py-2.5 text-sm font-medium text-white transition-all hover:bg-white/10">
                        @lang('Cancel')
                    </button>
                    <button wire:click="delete" class="flex-1 rounded-xl bg-rose-600 px-4 py-2.5 text-sm font-medium text-white shadow-lg shadow-rose-500/25 transition-all hover:bg-rose-700">
                        @lang('Delete')
                    </button>
                </div>
            </div>
        </div>
    @endif

    {{-- Logs Modal --}}
    @if($showLogsModal && $viewingJob)
        <div class="fixed inset-0 z-50 flex items-center justify-center overflow-y-auto bg-black/60 backdrop-blur-sm" wire:click.self="$set('showLogsModal', false)">
            <div class="relative w-full max-w-3xl max-h-[80vh] rounded-2xl border border-white/10 bg-[#12121a] shadow-2xl flex flex-col">
                <div class="flex items-center justify-between p-6 border-b border-white/10">
                    <div>
                        <h3 class="text-lg font-semibold text-white">@lang('Execution Logs')</h3>
                        <p class="text-sm text-slate-400">{{ $viewingJob->name }}</p>
                    </div>
                    <button wire:click="$set('showLogsModal', false)" class="flex h-8 w-8 items-center justify-center rounded-lg text-slate-400 transition-all hover:bg-white/10 hover:text-white">
                        <i class="ph-bold ph-x"></i>
                    </button>
                </div>

                <div class="flex-1 overflow-y-auto p-6">
                    @if(count($viewingLogs) > 0)
                        <div class="space-y-3">
                            @foreach($viewingLogs as $log)
                                <div class="rounded-xl border {{ $log['error'] ? 'border-rose-500/20 bg-rose-500/5' : 'border-white/10 bg-white/5' }} p-4">
                                    <div class="flex items-center justify-between">
                                        <div class="flex items-center gap-3">
                                            @if($log['error'])
                                                <div class="flex h-8 w-8 items-center justify-center rounded-lg bg-rose-500/20 text-rose-400">
                                                    <i class="ph-bold ph-x"></i>
                                                </div>
                                            @else
                                                <div class="flex h-8 w-8 items-center justify-center rounded-lg bg-emerald-500/20 text-emerald-400">
                                                    <i class="ph-bold ph-check"></i>
                                                </div>
                                            @endif
                                            <div>
                                                <div class="text-sm font-medium text-white">
                                                    {{ $log['error'] ? __('Failed') : __('Success') }}
                                                </div>
                                                <div class="text-xs text-slate-400">
                                                    {{ \Carbon\Carbon::parse($log['start_at'])->format('M d, Y H:i:s') }}
                                                </div>
                                            </div>
                                        </div>
                                        <div class="text-right">
                                            <div class="text-sm font-medium text-white">{{ $log['duration'] ?? 0 }}ms</div>
                                            <div class="text-xs text-slate-400">@lang('Duration')</div>
                                        </div>
                                    </div>
                                    @if($log['error'])
                                        <div class="mt-3 rounded-lg bg-rose-500/10 p-3">
                                            <code class="text-xs text-rose-400 break-all">{{ $log['error'] }}</code>
                                        </div>
                                    @endif
                                </div>
                            @endforeach
                        </div>
                    @else
                        <div class="text-center py-12">
                            <i class="ph-duotone ph-list-bullets text-5xl text-slate-600"></i>
                            <p class="mt-4 text-sm font-medium text-white">@lang('No logs yet')</p>
                            <p class="mt-1 text-xs text-slate-400">@lang('Run the cron job to see execution logs.')</p>
                        </div>
                    @endif
                </div>

                <div class="p-6 border-t border-white/10">
                    <button wire:click="$set('showLogsModal', false)" class="w-full rounded-xl border border-white/10 bg-white/5 px-4 py-2.5 text-sm font-medium text-white transition-all hover:bg-white/10">
                        @lang('Close')
                    </button>
                </div>
            </div>
        </div>
    @endif
</div>

