<div>
    {{-- Page Header --}}
    <x-admin.page-header :title="__('Cron Schedules')" :subtitle="__('Manage time intervals for cron jobs.')">
        <x-slot name="actions">
            <a href="{{ route('admin.cron.index') }}" class="inline-flex items-center gap-2 rounded-xl border border-white/10 bg-white/5 px-4 py-2.5 text-sm font-medium text-white transition-all hover:bg-white/10">
                <i class="ph-duotone ph-arrow-left"></i>
                @lang('Back to Cron Jobs')
            </a>
            <button wire:click="openAddModal" class="inline-flex items-center gap-2 rounded-xl bg-gradient-to-r from-purple-600 to-purple-700 px-4 py-2.5 text-sm font-medium text-white shadow-lg shadow-purple-500/25 transition-all hover:shadow-purple-500/40">
                <i class="ph-bold ph-plus"></i>
                @lang('Add Schedule')
            </button>
        </x-slot>
    </x-admin.page-header>

    {{-- Stats Cards --}}
    <div class="mt-6 grid grid-cols-1 gap-4 sm:grid-cols-2">
        <x-admin.stat-card
            :title="__('Total Schedules')"
            :value="$this->totalCount"
            icon="ph-duotone ph-timer"
            color="purple"
        />
        <x-admin.stat-card
            :title="__('Active Schedules')"
            :value="$this->activeCount"
            icon="ph-duotone ph-check-circle"
            color="emerald"
        />
    </div>

    {{-- Filters --}}
    <x-admin.card class="mt-6">
        <div class="flex flex-col gap-4 sm:flex-row sm:items-center sm:justify-between">
            <div class="relative flex-1">
                <i class="ph-duotone ph-magnifying-glass absolute left-3 top-1/2 -translate-y-1/2 text-slate-400"></i>
                <input
                    type="text"
                    wire:model.live.debounce.300ms="search"
                    placeholder="{{ __('Search schedules...') }}"
                    class="w-full rounded-xl border border-white/10 bg-white/5 py-2.5 pl-10 pr-4 text-sm text-white placeholder-slate-400 outline-none transition-all focus:border-purple-500/50 focus:ring-2 focus:ring-purple-500/20"
                />
            </div>
        </div>
    </x-admin.card>

    {{-- Schedules Grid --}}
    <div class="mt-6 grid grid-cols-1 gap-4 sm:grid-cols-2 lg:grid-cols-3 xl:grid-cols-4">
        @forelse($this->schedules as $schedule)
            <div class="group relative overflow-hidden rounded-2xl border border-white/10 bg-gradient-to-br from-[#12121a] to-[#0f0f15] p-5 transition-all hover:border-purple-500/30 hover:shadow-lg hover:shadow-purple-500/5">
                {{-- Status Badge --}}
                <div class="absolute right-3 top-3">
                    @if($schedule->status)
                        <span class="inline-flex items-center gap-1.5 rounded-lg border border-emerald-500/20 bg-emerald-500/10 px-2 py-0.5 text-xs font-medium text-emerald-400">
                            <span class="h-1.5 w-1.5 rounded-full bg-emerald-400 animate-pulse"></span>
                            @lang('Active')
                        </span>
                    @else
                        <span class="inline-flex items-center gap-1.5 rounded-lg border border-slate-500/20 bg-slate-500/10 px-2 py-0.5 text-xs font-medium text-slate-400">
                            @lang('Inactive')
                        </span>
                    @endif
                </div>

                {{-- Schedule Icon --}}
                <div class="mb-4 flex h-12 w-12 items-center justify-center rounded-xl bg-gradient-to-br from-purple-500/20 to-purple-600/10 text-purple-400">
                    <i class="ph-duotone ph-timer text-2xl"></i>
                </div>

                {{-- Schedule Info --}}
                <h3 class="mb-1 text-base font-semibold text-white">{{ $schedule->name }}</h3>
                <p class="mb-3 text-xs text-slate-400">{{ $this->formatInterval($schedule->interval) }}</p>

                {{-- Jobs Count --}}
                <div class="mb-4 flex items-center gap-4 text-xs text-slate-400">
                    <div class="flex items-center gap-1">
                        <i class="ph-duotone ph-clock-countdown"></i>
                        <span>{{ $schedule->cron_jobs_count }} @lang('jobs')</span>
                    </div>
                    <div class="flex items-center gap-1">
                        <i class="ph-duotone ph-hourglass"></i>
                        <span>{{ $schedule->interval }}s</span>
                    </div>
                </div>

                {{-- Actions --}}
                <div class="flex items-center gap-2 border-t border-white/5 pt-4">
                    <button
                        wire:click="openEditModal({{ $schedule->id }})"
                        class="flex-1 rounded-xl border border-white/10 bg-white/5 px-3 py-2 text-center text-xs font-medium text-white transition-all hover:bg-white/10"
                    >
                        <i class="ph-duotone ph-pencil-simple mr-1"></i>
                        @lang('Edit')
                    </button>
                    <button
                        wire:click="toggleStatus({{ $schedule->id }})"
                        class="rounded-xl px-3 py-2 text-xs font-medium transition-all cursor-pointer {{ $schedule->status ? 'border border-rose-500/20 bg-rose-500/10 text-rose-400 hover:bg-rose-500/20' : 'border border-emerald-500/20 bg-emerald-500/10 text-emerald-400 hover:bg-emerald-500/20' }}"
                    >
                        {{ $schedule->status ? __('Disable') : __('Enable') }}
                    </button>
                </div>
            </div>
        @empty
            <div class="col-span-full">
                <x-admin.card>
                    <div class="py-12 text-center">
                        <i class="ph-duotone ph-timer text-5xl text-slate-600"></i>
                        <p class="mt-4 text-sm font-medium text-white">@lang('No schedules found')</p>
                        <p class="mt-1 text-xs text-slate-400">@lang('Run the schedule seeder or add a new schedule.')</p>
                    </div>
                </x-admin.card>
            </div>
        @endforelse
    </div>

    {{-- Pagination --}}
    @if($this->schedules->hasPages())
        <div class="mt-6">
            {{ $this->schedules->links() }}
        </div>
    @endif

    {{-- Add/Edit Schedule Modal --}}
    @if($showModal)
        <div class="fixed inset-0 z-50 flex items-center justify-center overflow-y-auto bg-black/60 backdrop-blur-sm" wire:click.self="$set('showModal', false)">
            <div class="relative w-full max-w-lg rounded-2xl border border-white/10 bg-gradient-to-br from-[#12121a] to-[#0f0f15] p-6 shadow-2xl">
                <div class="mb-6 flex items-center justify-between">
                    <h3 class="text-lg font-semibold text-white">{{ $editingId ? __('Edit Schedule') : __('Add Schedule') }}</h3>
                    <button wire:click="$set('showModal', false)" class="flex h-8 w-8 items-center justify-center rounded-lg text-slate-400 transition-all hover:bg-white/10 hover:text-white">
                        <i class="ph-bold ph-x"></i>
                    </button>
                </div>

                <form wire:submit="save" class="space-y-4">
                    <div>
                        <label class="mb-1.5 block text-sm font-medium text-slate-300">@lang('Name') <span class="text-rose-400">*</span></label>
                        <input type="text" wire:model="name" class="w-full rounded-xl border border-white/10 bg-white/5 px-4 py-2.5 text-sm text-white placeholder-slate-400 outline-none transition-all focus:border-purple-500/50 focus:ring-2 focus:ring-purple-500/20" placeholder="@lang('e.g., 5 Minutes')">
                        @error('name') <span class="mt-1 text-xs text-rose-400">{{ $message }}</span> @enderror
                    </div>

                    <div>
                        <label class="mb-1.5 block text-sm font-medium text-slate-300">@lang('Interval') <span class="text-rose-400">*</span></label>
                        <select wire:model="interval" class="w-full rounded-xl border border-white/10 bg-white/5 px-4 py-2.5 text-sm text-white outline-none transition-all focus:border-purple-500/50 focus:ring-2 focus:ring-purple-500/20">
                            @foreach($this->getIntervalOptions() as $value => $label)
                                <option value="{{ $value }}" class="bg-[#12121a]">{{ $label }}</option>
                            @endforeach
                        </select>
                        @error('interval') <span class="mt-1 text-xs text-rose-400">{{ $message }}</span> @enderror
                        <p class="mt-1.5 text-xs text-slate-500">@lang('How often the cron job should run.')</p>
                    </div>

                    <div class="flex items-center gap-3 pt-4">
                        <button type="button" wire:click="$set('showModal', false)" class="flex-1 rounded-xl border border-white/10 bg-white/5 px-4 py-2.5 text-sm font-medium text-white transition-all hover:bg-white/10">
                            @lang('Cancel')
                        </button>
                        <button type="submit" class="flex-1 rounded-xl bg-gradient-to-r from-purple-600 to-purple-700 px-4 py-2.5 text-sm font-medium text-white shadow-lg shadow-purple-500/25 transition-all hover:shadow-purple-500/40">
                            {{ $editingId ? __('Update') : __('Create') }}
                        </button>
                    </div>
                </form>
            </div>
        </div>
    @endif
</div>

