<div>
    {{-- Page Header --}}
    <x-admin.page-header :title="$cronJob->name . ' ' . __('Logs')" :subtitle="__('View execution history and errors for this cron job.')">
        <x-slot name="actions">
            <a href="{{ route('admin.cron.index') }}" class="inline-flex items-center gap-2 rounded-xl border border-white/10 bg-white/5 px-4 py-2.5 text-sm font-medium text-white transition-all hover:bg-white/10">
                <i class="ph-duotone ph-arrow-left"></i>
                @lang('Back to Cron Jobs')
            </a>
            @if($this->totalCount > 0)
                <button wire:click="openFlushModal" class="inline-flex items-center gap-2 rounded-xl border border-rose-500/20 bg-rose-500/10 px-4 py-2.5 text-sm font-medium text-rose-400 transition-all hover:bg-rose-500/20">
                    <i class="ph-bold ph-trash"></i>
                    @lang('Flush Logs')
                </button>
            @endif
        </x-slot>
    </x-admin.page-header>

    {{-- Stats Cards --}}
    <div class="mt-6 grid grid-cols-1 gap-4 sm:grid-cols-3">
        <x-admin.stat-card
            :title="__('Total Logs')"
            :value="$this->totalCount"
            icon="ph-duotone ph-list-bullets"
            color="purple"
        />
        <x-admin.stat-card
            :title="__('Successful')"
            :value="$this->successCount"
            icon="ph-duotone ph-check-circle"
            color="emerald"
        />
        <x-admin.stat-card
            :title="__('Errors')"
            :value="$this->errorCount"
            icon="ph-duotone ph-warning-circle"
            color="rose"
        />
    </div>

    {{-- Filters --}}
    <x-admin.card class="mt-6">
        <div class="flex flex-col gap-4 sm:flex-row sm:items-center sm:justify-between">
            <div class="flex items-center gap-2">
                <span class="text-sm text-slate-400">@lang('Filter'):</span>
                <div class="flex items-center gap-2">
                    <button
                        wire:click="$set('filter', '')"
                        class="rounded-lg px-3 py-1.5 text-xs font-medium transition-all {{ $filter === '' ? 'bg-purple-500/20 text-purple-400 border border-purple-500/30' : 'border border-white/10 bg-white/5 text-slate-400 hover:bg-white/10' }}"
                    >
                        @lang('All')
                    </button>
                    <button
                        wire:click="$set('filter', 'success')"
                        class="rounded-lg px-3 py-1.5 text-xs font-medium transition-all {{ $filter === 'success' ? 'bg-emerald-500/20 text-emerald-400 border border-emerald-500/30' : 'border border-white/10 bg-white/5 text-slate-400 hover:bg-white/10' }}"
                    >
                        @lang('Success')
                    </button>
                    <button
                        wire:click="$set('filter', 'errors')"
                        class="rounded-lg px-3 py-1.5 text-xs font-medium transition-all {{ $filter === 'errors' ? 'bg-rose-500/20 text-rose-400 border border-rose-500/30' : 'border border-white/10 bg-white/5 text-slate-400 hover:bg-white/10' }}"
                    >
                        @lang('Errors')
                    </button>
                </div>
            </div>
        </div>
    </x-admin.card>

    {{-- Logs Table --}}
    <x-admin.card class="mt-6 overflow-hidden">
        <div class="overflow-x-auto">
            <table class="w-full">
                <thead>
                    <tr class="border-b border-white/10 text-left text-xs font-medium uppercase tracking-wider text-slate-400">
                        <th class="px-4 py-3">@lang('Started At')</th>
                        <th class="px-4 py-3">@lang('Ended At')</th>
                        <th class="px-4 py-3">@lang('Duration')</th>
                        <th class="px-4 py-3">@lang('Status')</th>
                        <th class="px-4 py-3 text-right">@lang('Actions')</th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-white/5">
                    @forelse($this->logs as $log)
                        <tr class="transition-colors hover:bg-white/[0.02]">
                            <td class="px-4 py-4">
                                <div class="text-sm text-white">{{ $log->start_at ? \Carbon\Carbon::parse($log->start_at)->format('M d, Y H:i:s') : '--' }}</div>
                            </td>
                            <td class="px-4 py-4">
                                <div class="text-sm text-white">{{ $log->end_at ? \Carbon\Carbon::parse($log->end_at)->format('M d, Y H:i:s') : '--' }}</div>
                            </td>
                            <td class="px-4 py-4">
                                <span class="inline-flex items-center gap-1.5 rounded-lg border border-purple-500/20 bg-purple-500/10 px-2 py-1 text-xs font-medium text-purple-400">
                                    <i class="ph-duotone ph-timer"></i>
                                    {{ $log->duration }}s
                                </span>
                            </td>
                            <td class="px-4 py-4">
                                @if($log->error)
                                    <div class="flex items-start gap-2">
                                        <span class="inline-flex items-center gap-1.5 rounded-lg border border-rose-500/20 bg-rose-500/10 px-2 py-1 text-xs font-medium text-rose-400">
                                            <i class="ph-bold ph-warning"></i>
                                            @lang('Error')
                                        </span>
                                    </div>
                                    <div class="mt-2 max-w-md rounded-lg border border-rose-500/20 bg-rose-500/5 p-2">
                                        <p class="text-xs text-rose-300 break-words">{{ \Illuminate\Support\Str::limit($log->error, 150) }}</p>
                                    </div>
                                @else
                                    <span class="inline-flex items-center gap-1.5 rounded-lg border border-emerald-500/20 bg-emerald-500/10 px-2 py-1 text-xs font-medium text-emerald-400">
                                        <i class="ph-bold ph-check"></i>
                                        @lang('Success')
                                    </span>
                                @endif
                            </td>
                            <td class="px-4 py-4">
                                <div class="flex items-center justify-end gap-2">
                                    @if($log->error)
                                        <button
                                            wire:click="resolveError({{ $log->id }})"
                                            class="flex h-8 w-8 items-center justify-center rounded-lg border border-white/10 bg-white/5 text-slate-400 transition-all hover:bg-emerald-500/20 hover:text-emerald-400 hover:border-emerald-500/30"
                                            title="@lang('Mark as Resolved')"
                                        >
                                            <i class="ph-bold ph-check text-sm"></i>
                                        </button>
                                    @endif
                                </div>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="5" class="px-4 py-12 text-center">
                                <i class="ph-duotone ph-list-bullets text-5xl text-slate-600"></i>
                                <p class="mt-4 text-sm font-medium text-white">@lang('No logs found')</p>
                                <p class="mt-1 text-xs text-slate-400">@lang('This cron job has not been executed yet.')</p>
                            </td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </x-admin.card>

    {{-- Pagination --}}
    @if($this->logs->hasPages())
        <div class="mt-6">
            {{ $this->logs->links() }}
        </div>
    @endif

    {{-- Flush Confirmation Modal --}}
    @if($showFlushModal)
        <div class="fixed inset-0 z-50 flex items-center justify-center overflow-y-auto bg-black/60 backdrop-blur-sm" wire:click.self="$set('showFlushModal', false)">
            <div class="relative w-full max-w-md rounded-2xl border border-white/10 bg-gradient-to-br from-[#12121a] to-[#0f0f15] p-6 shadow-2xl">
                <div class="mb-6 text-center">
                    <div class="mx-auto mb-4 flex h-16 w-16 items-center justify-center rounded-full bg-rose-500/20 text-rose-400">
                        <i class="ph-duotone ph-trash text-3xl"></i>
                    </div>
                    <h3 class="text-lg font-semibold text-white">@lang('Flush All Logs')</h3>
                    <p class="mt-2 text-sm text-slate-400">@lang('Are you sure you want to delete all logs for this cron job? This action cannot be undone.')</p>
                </div>

                <div class="flex items-center gap-3">
                    <button wire:click="$set('showFlushModal', false)" class="flex-1 rounded-xl border border-white/10 bg-white/5 px-4 py-2.5 text-sm font-medium text-white transition-all hover:bg-white/10">
                        @lang('Cancel')
                    </button>
                    <button wire:click="flushLogs" class="flex-1 rounded-xl bg-gradient-to-r from-rose-600 to-rose-700 px-4 py-2.5 text-sm font-medium text-white shadow-lg shadow-rose-500/25 transition-all hover:shadow-rose-500/40">
                        @lang('Flush All')
                    </button>
                </div>
            </div>
        </div>
    @endif
</div>

